<?php

namespace Fir\Models;

class Admin extends Model {

    /**
     * @var string
     */
    public $username;

    /**
     * @var string
     */
    public $password;

    /**
     * @var string
     */
    public $rememberToken;
	
    /**
     * Update the Admin Profile Details
     *
     */
    public function profileDetails($name, $username, $email, $adminid) {

		$Update = $this->db->update('admin',[
		   'name' => $name,
		   'username' => $username,
		   'email' => $email,
		],[
		    'adminid' => $adminid
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Admin Profile Image
     *
     */
    public function profileImage($filename, $adminid) {

		$Update = $this->db->update('admin',[
		   'imagelocation' => $filename,
		],[
		    'adminid' => $adminid
		  ]);
		  
		return $Update->rowCount();  
    }	
	
    /**
     * Update the Admin Panel Password
     *
     */
    public function password($password, $adminid) {

		$Update = $this->db->update('admin',[
		   'password' => $password,
		],[
		    'adminid' => $adminid
		  ]);
		  
		return $Update->rowCount();  
    }
    
    public function count_categories() {
	   $no = $this->db->count("categories", []); 
	   return $no;
    }	
    public function count_voters() {
	   $no = $this->db->count("user", ["user_type" => 1]); 
	   return $no;
    }	
    public function count_candidates() {
	   $no = $this->db->count("user", ["user_type" => 2]); 
	   return $no;
    }    
    public function has_start() {
	   $no = $this->db->has('start', []); 
	   return $no;
    }   
    public function start() {
	   $no = $this->db->select('start', '*', ["LIMIT" => 1, "ORDER" =>["id" => "DESC"]]); 
	   return $no;
    }   
    public function start_array() {
	   $start_array = $this->db->select('start', '*', ["LIMIT" => 1, "ORDER" =>["id" => "DESC"]]);
       foreach ($start_array as $start) {}
	   return $start;
    }    
    public function update_voting($title, $date_to_start, $date_to_end, $description, $id, $en_date_to_start, $en_date_to_end) {

		$Update = $this->db->update('start',[
		   'title' => $title,
		   'date_to_start' => $date_to_start,
		   'date_to_end' => $date_to_end,
		   'description' => $description,
		   'en_date_to_start' => $en_date_to_start,
		   'en_date_to_end' => $en_date_to_end,
		],[
		    'id' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
    public function start_voting($title, $date_to_start, $date_to_end, $description) {
		
	    $Insert = $this->db->insert('start', array(
		   'title' => $title,
		   'date_to_start' => $date_to_start,
		   'date_to_end' => $date_to_end,
		   'description' => $description
		));	
		  
		return $Insert->rowCount();  
    }	
    public function select_all_users(){
    	return $candidates = $this->db->select('user', '*');
    }

    public function select_sms_logs(){
        return $candidates = $this->db->select('sms_logs', '*', ["visible" => 1] , ["ORDER" =>["id" => "DESC"]]);
    }
    
    public function update_sms_visible() {

		$Update = $this->db->update('sms_logs',['visible' => '0']);
		return $Update->rowCount();  
		
    }

    public function select_mobile($send_type){

    	$mobile = null;

    	switch ($send_type) {
    		case '0':
    			$mobile = $this->db->select('user', 'mobile');
    			break;

    		case '1':
    			$mobile = $this->db->select('user', 'mobile', ["user_type" => 2]);
    			break;

    		case '2':
    			$mobile = $this->db->select('user', 'mobile', ["user_type" => 1]);
    			break;

    		case '3':
    			$mobile = $this->db->select('user', 'mobile', ["user_type" => 2, "approved" => 1]);
    			break;

    		case '4':
    			$mobile = $this->db->select('user', 'mobile', ["user_type" => 1, "approved" => 1]);
    			break;
    		
    		default:
    			# code...
    			break;
    	}

    	return $mobile;
    }

    public function insert_sms_logs($mobile, $message, $status) {
        
        $Insert = $this->db->insert('sms_logs', array(
           'mobile_number' => $mobile,
           'message' => $message,
           'status' => $status,
           'date_added' => date("Y-m-d H:i:s")
        )); 
          
        return $Insert->rowCount();  
    }   
    
    public function insert_admin($name, $email, $mobile, $password, $adminId) {
		
	    $Insert = $this->db->insert('admin', array(
		   'name' => $name,
		   'email' => $email,
		   'username' => $email,
		   'password' => $password,
		   'adminid' => $adminId,
		   'user_type' => 1,
		   'mobile' => $mobile,
		   'joined' => date("Y-m-d H:i:s")
		));	
		  
		return $Insert->rowCount();  
    }	
    
    public function select_admins(){
        return  $this->db->select('admin', '*', ["user_type" => 1], ["ORDER" =>["id" => "DESC"]]);
    }
    
    public function get_admin($id){
        $admin = $this->db->select('admin', '*', ["id" => $id]);
        foreach($admin as $row){}	
        return $row;
    }
    
    public function has_admin($id) {
	   $no = $this->db->has("admin", ["id" => $id]); 
	   return $no;
    }   
    
    public function update_admin($name, $email, $mobile, $adminid) {

		$Update = $this->db->update('admin',[
		   'name' => $name,
		   'username' => $email,
		   'email' => $email,
		   'mobile' => $mobile,
		],[
		    'id' => $adminid
		  ]);
		  
		return $Update->rowCount();  
    }

}