<?php
defined('FIR') OR exit();
/**
 * The template for displaying Home page content
 */
?>


    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <!-- [ breadcrumb ] start -->

                    <!-- [ breadcrumb ] end -->
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ Main Content ] start -->
                            <div class="row">
                                <!--[ daily sales section ] start-->
                                <div class="col-md-6 col-xl-4">
                                    <div class="card daily-sales">
                                        <div class="card-block">
                                            <h6 class="mb-4"><?=$this->lang('voters')?></h6>
                                            <div class="row d-flex align-items-center">
                                                <div class="col-9">
                                                    <h3 class="f-w-300 d-flex align-items-center m-b-0"><i class="feather icon-users text-c-duuuunk f-30 m-r-10"></i> <?=e($data['count_voters'])?></h3>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-xl-4">
                                    <div class="card daily-sales">
                                        <div class="card-block">
                                            <h6 class="mb-4"><?=$this->candidate_name_plural()?></h6>
                                            <div class="row d-flex align-items-center">
                                                <div class="col-9">
                                                    <h3 class="f-w-300 d-flex align-items-center m-b-0"><i class="feather icon-users text-c-duuuunk f-30 m-r-10"></i> <?=e($data['count_candidates'])?></h3>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-xl-4">
                                    <div class="card daily-sales">
                                        <div class="card-block">
                                            <h6 class="mb-4"><?=$this->category_name_plural()?></h6>
                                            <div class="row d-flex align-items-center">
                                                <div class="col-9">
                                                    <h3 class="f-w-300 d-flex align-items-center m-b-0"><i class="feather icon-layers text-c-duuuunk f-30 m-r-10"></i> <?=e($data['count_categories'])?></h3>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
								

                            </div>
							<div class="row">
							    <div class="col-md-8">

                               <?=$this->message()?>
                               <?=$this->validation()?>


                            <?php if(e($data['has_start']) == true): ?> 

                                    <div class="card Recent-Users">
                                        <div class="card-header">
                                            <h5><?=$this->lang('your_voting')?></h5>
                                        </div>
                                        <div class="card-block px-3 py-3">
                                            <div class="table-responsive">
                                                <table class="table table-hover">
                                                    <thead>
                                                      <tr>
                                                       <th><?=$this->lang('title')?></th>
                                                       <th><?=$this->lang('date_to_start')?></th>
                                                       <th><?=$this->lang('date_to_end')?></th>
                                                       <th><?=$this->lang('finish_voting')?></th>
                                                       <th><?=$this->lang('action')?></th>
                                                      </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                        foreach($data['start'] as $row) {

                                                        echo '<tr id="tr'.e($row["id"]).'">';
                                                        echo '<td><h6 class="text-muted mb-1">'. e($row["title"]) .'</h6></td>';
                                                        echo '<td><h6 class="text-muted">'. e($row["date_to_start"]) .'</h6></td>';
                                                        echo '<td><h6 class="text-muted">'. e($row["date_to_end"]) .'</h6></td>';
                                                    if(e($row["end"]) == 0):
                                                        echo '<td><a id="finish_voting" data-id="' . e($row["id"]) . '" class="btn btn-danger text-white">Finish Voting</a></td>';
                                                    else:
                                                        echo '<td><h6 class="text-muted">'. $this->lang('ended_on').':- ' . e($row["date_ended"]) . '</h6>
                                                            <a id="resume_voting" data-id="' . e($row["id"]) . '" class="btn btn-secondary text-white">'. $this->lang('resume_voting').'</a></td>';
                                                    endif;  
                                                        echo '<td>';    
                                                     if(e($row["end"]) == 0):       
                                                        echo '<button type="button" class="btn btn-success" data-toggle="modal" data-target="#exampleModal">
                                                              '. $this->lang('edit') .'
                                                             </button>
                                                          ';
                                                    endif;
                                                        echo '<a id="delete_voting" data-id="' . e($row["id"]) . '" class="btn btn-danger btn-xs text-white" data-toggle="tooltip" title="'. $this->lang('delete') .'"><span class="fa fa-trash"></span></a>';
                                                     echo '</td>';        
                                                        echo '</tr>';
                                                       }
                                                    ?>  
                                                    </tbody>
                                                    <thead>
                                                      <tr>
                                                       <th><?=$this->lang('title')?></th>
                                                       <th><?=$this->lang('date_to_start')?></th>
                                                       <th><?=$this->lang('date_to_end')?></th>
                                                       <th><?=$this->lang('finish_voting')?></th>
                                                       <th><?=$this->lang('action')?></th>
                                                      </tr>
                                                    </thead>
                                                </table>
                                            </div>
                                        </div>
                                    </div> 

                                    <!-- Modal -->
                                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                      <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                          <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel"><?=$this->lang('edit_your_voting')?></h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                              <span aria-hidden="true">&times;</span>
                                            </button>
                                          </div>

                                    <form action="<?=$this->siteUrl()?>/admin/dashboard" method="post">
                                        
                                          <div class="modal-body">

                                     <?php foreach($data['start'] as $row): ?>

                                        <input type="hidden" name="id" class="form-control" value="<?=e($row['id'])?>" />

                                        <div class="form-group">
                                            <label><?=$this->lang('title_of_your_voting')?> e.g The Masha Brand company competitions</label>
                                            <input type="text" name="title" class="form-control" value="<?=e($row['title'])?>">
                                        </div>
                                        <div class="form-group">
                                            <label><?=$this->lang('date_when_voting_start')?> (<?=$this->lang('click_icon')?>)</label>
                                            <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                                <input type="text" name="date_to_start" class="form-control datetimepicker-input" size="40" data-target="#datetimepicker1" value="<?=e($row['date_to_start'])?>"/>
                                                <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                                    <div class="input-group-text"><i class="fa fa-calendar-alt"></i></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label><?=$this->lang('date_when_voting_start')?> (<?=$this->lang('click_icon')?>)</label>
                                            <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                                <input type="text" name="date_to_end" class="form-control datetimepicker-input" size="40" data-target="#datetimepicker2" value="<?=e($row['date_to_end'])?>"/>
                                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                                    <div class="input-group-text"><i class="fa fa-calendar-alt"></i></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label><?=$this->lang('description')?></label>
                                            <textarea type="text" name="description" class="form-control"><?=e($row['description'])?></textarea>
                                        </div>

                                     <?php endforeach; ?> 

                                       <?=$this->token()?>


                                          </div>
                                          <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal"><?=$this->lang('close')?></button>
                                            <button type="submit" name="edit_voting" class="btn btn-primary"><?=$this->lang('save_changes')?></button>
                                          </div>

                                    </form>
                                        </div>
                                      </div>
                                    </div>                                     

                            <?php else: ?>     
                                    <div class="card">
                                        <div class="card-header">
                                            <h5><?=$this->lang('start_your_voting')?></h5>
                                        </div>
                                        <div class="card-body">

                                    <form action="<?=$this->siteUrl()?>/admin/dashboard" method="post">

                                        <div class="form-group">
                                            <label><?=$this->lang('title_of_your_voting')?> e.g The Masha Brand company competitions</label>
                                            <input type="text" name="title" class="form-control" placeholder="<?=$this->lang('title_of_your_voting')?> e.g The Masha Brand company competitions">
                                        </div>
                                        <div class="form-group">
                                            <label><?=$this->lang('date_when_voting_start')?> (<?=$this->lang('click_icon')?>)</label>
                                            <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                                <input type="text" name="date_to_start" class="form-control datetimepicker-input" size="40" data-target="#datetimepicker1"/>
                                                <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                                    <div class="input-group-text"><i class="fa fa-calendar-alt"></i></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label><?=$this->lang('date_when_voting_start')?> (<?=$this->lang('click_icon')?>)</label>
                                            <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                                <input type="text" name="date_to_end" class="form-control datetimepicker-input" size="40" data-target="#datetimepicker2"/>
                                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                                    <div class="input-group-text"><i class="fa fa-calendar-alt"></i></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label><?=$this->lang('description')?></label>
                                            <textarea type="text" name="description" class="form-control" placeholder="<?=$this->lang('description')?>"></textarea>
                                        </div>

                                       <?=$this->token()?>

                                        <button type="submit" name="start_voting" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                    </form>
										</div>
									</div>

                                <?php endif; ?>   	
								</div>	
                                <div class="col-md-4">
                                    <div class="card">
                                        <div class="card-header">
                                            <h5>Instructions</h5>
                                        </div>
                                        <div class="card-body">
                                            <p class="lead m-t-0">Starting your voting system</p>
                                            After you have set your <mark>title + start date & end date</mark> then you can now start to add <mark>categories + nominees</mark>.
                                            <br>
                                            <br>
                                            You can delete your voting which will include deleting <mark>categories + nominees</mark>.
                                            <br>
                                            <br>
                                            <mark>Finish Voting</mark> means that voters cannot vote. You can still resume the voting, where the voting will continue until the date you set for end of voting.
                                        </div>
                                    </div>
                                </div>
							</div><!--/row --> 
                            <!-- [ Main Content ] end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- [ Main Content ] end -->

<link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/tempusdominus-bootstrap-4/tempusdominus-bootstrap-4.css" />
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.22.2/moment.min.js"></script>
<script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/tempusdominus-bootstrap-4/tempusdominus-bootstrap-4.js"></script>
<script type="text/javascript">
    $(function () {
        $('#datetimepicker1').datetimepicker({
            format: 'L',
            format: 'YYYY/MM/DD'
        });			
        $('#datetimepicker2').datetimepicker({
            format: 'L',
            format: 'YYYY/MM/DD'
        });	
    });
</script>
