<?php
defined('FIR') OR exit();
/**
 * The template for displaying Home page menu
 */
?>

	  
       <!-- ==============================================
	    Hero Section
	    =============================================== -->	
        <section>
            <!-- Hero Slide-->
            <div class="hero-slide bg-size bg-center py-5" style="background: url(<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($this->siteSettings('home_bg'))?>)">
              <div class="container text-white py-5 index-forward">
                <div class="row">
                  <div class="col-lg-7">
                    <h1><?=e($data['start']['title'])?></h1>
                    <p class="lead pb-4"><?=e($data['start']['description'])?></p>
                 <?php if(e($data['start']['end']) == 1): ?>      
                    <h5><span class="badge badge-secondary"><?=$this->lang('voting_ended')?></span></h5>
                 <?php elseif(e($data['start']['date_to_end']) == e($data['date_to_now'])): ?>
                    <h5><span class="badge badge-secondary"><?=$this->lang('voting_ended')?></span></h5>   
                 <?php else: ?>      
                    <h5><span class="badge badge-secondary"><?=$this->lang('voting_in_progress')?></span></h5>   
                 <?php endif; ?>        
                    <h4 class=""><?=$this->lang('from')?> <?=strftime("%b %d, %Y", strtotime($data['start']['date_to_start'])); ?> - <?=strftime("%b %d, %Y", strtotime($data['start']['date_to_end'])); ?></h4>
                  </div>
                </div>
              </div>
            </div>
        </section>

	    <!-- ==============================================
	    Categories Section
	    =============================================== -->	
        <section class="py-5">
          <div class="container pb-5">
            <header class="text-center mb-5">
              <h2 class="mb-1"><?=$this->category_name_plural()?></h2>
              <p class="text-muted text-small"><?=$this->lang('click_to_view')?> <?=$this->candidate_name_plural()?></p>
            </header>
            <div class="row text-center">
             
             <?php foreach($data['categories'] as $row): ?>    
                  <div class="col-lg-3 px-lg-2">
                    <div class="categories-item card border-0 shadow mb-4 reset-anchor hover-transition">
                      <div class="card-body px-4 py-5">
                        <h2 class="h5"> <a class="stretched-link reset-anchor-inherit" href="<?=$this->siteUrl()?>/<?=$this->category_url()?>/<?=e($row['slug'])?>"><?=e($row['title'])?></a></h2>
                          
                         <?php foreach($data['count'] as $ct): ?>
                          
                           <?php if($ct['category_id'] == $row['id']): ?>

                            <p class="categories-item-number small mb-0"><?=e($ct['g'])?> - <?=$this->candidate_name_plural()?></p>
                          
                           <?php endif; ?>

                         <?php endforeach; ?>                               
                          
                      </div>
                    </div>
                  </div>
             <?php endforeach; ?>     
              
            </div>
          </div>
        </section>