<?php
defined('FIR') OR exit();
/**
 * The template for displaying Home page content
 */
?>
<!-- [ Main Content ] start -->
    <div align="right" class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">


                                    <div class="card Recent-Users">
                                        <div class="card-header">
                                            <h4><?=$this->lang('verify_registered_voters')?></h4>
                                        </div>
                                        <div class="card-block px-3 py-3">
                                            <div class="table-responsive">
                                                <table class="table table-hover" id="myTable">
                                                  <thead>
                                                    <tr>
                                                     <th><h6><?=$this->lang('name')?></h6></th>
                                                     <th><h6><?=$this->lang('cpr')?></h6></th>
                                                     <th><h6><?=$this->lang('mobile')?></h6></th>
                                                     <th><h6><?=$this->lang('approved_or_not')?></h6></th>
                                                     <th><h6><?=$this->lang('action')?></h6></th>
                                                    </tr>
                                                  </thead>
                                                    <tbody>
                                                    <?php
                                                        foreach($data['voters'] as $row) {

                                                        echo '<tr id="tr'.e($row["id"]).'">';
                                                        echo '<td>
                                                                  <h4>'. e($row["name"]) .'</h4>
                                                              </td>';
                                                        echo '<td>
                                                                  <h4>'. e($row["cpr"]) .'</h4>
                                                              </td>';
                                                        echo '<td>
                                                                  <h4>'. e($row["mobile"]) .'</h4>
                                                              </td>';
                                                        echo '<td>';
                                                              if($row['approved'] == 1):
                                                                echo '<h4 class="text-muted">'. $this->lang('approved') .'</h4>';
                                                              elseif($row['approved'] == 0):
                                                                echo '<h4 class="text-muted">'. $this->lang('waiting_approved') .'</h4>';
                                                              elseif($row['approved'] == 2): 
                                                                echo '<h4 class="text-muted">'. $this->lang('declined') .'</h4>';
                                                              endif; 
                                                        echo '</td>';            
                                                        echo '<td>
                                                          <a id="approve_voter" data-id="' . e($row["id"]) . '" class="btn btn-success btn-xs text-white">'. $this->lang('approve') .'</a>
                                                          <a id="decline_voter" data-id="' . e($row["id"]) . '" class="btn btn-danger btn-xs text-white">'. $this->lang('decline') .'</a>
                                                          <button class="btn btn-primary" onClick="updateVoter(\''.e($row["id"]).'\',\''.e($row["name"]).'\',\''.e($row["email"]).'\',\''.e($row["cpr"]).'\',\''.e($row["mobile"]).'\')"><b class="fa fa-pen"></b></button>
                                                          <button class="btn btn-info" onClick="sendSms('.e($row["mobile"]).')"><b class="fa fa-envelope"></b></button>

                                                          </td>';
                                                        echo '</tr>';
                                                       }
                                                    ?>
                                                    </tbody>
                                                 
                                                </table>
                                            </div>
                                        </div>
                                    </div>   

                                        
      
            </div>
        </div>
    </div>
    <!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
        <h5 class="modal-title" id="exampleModalLabel"><?=$this->lang('voter_title')?></h5>
      </div>
      <div class="modal-body">
        
        <form action="<?=$this->siteUrl()?>/register" id="add_voter_form" method="post">
            <div class="form-group mb-3">
                <input required id="name" title="<?=$this->lang('name')?> is required" name="name" type="text" value="<?php if(isset($_POST['name'])){ echo $_POST['name']; } ?>" placeholder="<?=$this->lang('name')?>" class="form-control rounded-pill border-0 shadow-sm px-4">
            </div>
            <div class="form-group mb-3">
                <input required id="email" name="email" type="email" value="<?php if(isset($_POST['email'])){ echo $_POST['email']; } ?>" placeholder="<?=$this->lang('email')?>" class="form-control rounded-pill border-0 shadow-sm px-4">
            </div>
            <div class="form-group mb-3">
                <input required id="cpr" name="cpr" type="text" maxlength="<?=e($data['settings']['cpr_char_limit'])?>" minlength="<?=e($data['settings']['cpr_char_limit'])?>" value="<?php if(isset($_POST['cpr'])){ echo $_POST['cpr']; } ?>" placeholder="<?=$this->lang('cpr')?>" class="form-control rounded-pill border-0 shadow-sm px-4">
            </div>
            <div class="form-group mb-3">
                <input required id="mobile" name="mobile" type="text" maxlength="<?=e($data['settings']['sms_char_limit'])?>" minlength="<?=e($data['settings']['sms_char_limit'])?>" value="<?php if(isset($_POST['mobile'])){ echo $_POST['mobile']; } ?>" placeholder="<?=$this->lang('mobile')?>" class="form-control rounded-pill border-0 shadow-sm px-4">
            </div>
            <!--<div class="form-group mb-3">-->
            <!--    <input id="password" name="password" type="password" value="<?php if(isset($_POST['password'])){ echo $_POST['password']; } ?>" placeholder="<?=$this->lang('password')?>" class="form-control rounded-pill border-0 shadow-sm px-4 text-primary">-->
            <!--</div>-->
            <!--<div class="form-group mb-3">-->
            <!--    <input id="cpassword" name="confirmPassword" type="password" value="<?php if(isset($_POST['confirmPassword'])){ echo $_POST['confirmPassword']; } ?>" placeholder="<?=$this->lang('confirm_password')?>" class="form-control rounded-pill border-0 shadow-sm px-4 text-primary">-->
            <!--</div>-->
            <input type="hidden" id="id" name="voter_id" />
            <input type="hidden" id="submit_type" name="submit_type" />
            <?=$this->token()?>
            
            <button type="submit" name="register" class="btn btn-primary btn-block text-uppercase mt-2 mb-2 rounded-pill shadow-sm"><?=$this->lang('register')?></button>
            <button type="button" class="btn btn-secondary btn-block text-uppercase mt-2 mb-2 rounded-pill shadow-sm" data-dismiss="modal"><?=$this->lang('close')?></button>
            
        </form>
      </div>
    </div>
  </div>
</div>
    <!-- [ Main Content ] end -->