<?php
defined('FIR') OR exit();
/**
 * The main template file
 * This file puts together the three main section of the software, header, content and footer
 */
?>

<!DOCTYPE html>
<?php if($data['lang'] == "english"){ ?>
    <html>
<?php }else{ ?>
    <html dir="rtl">
<?php } ?>

	<head>
	    <!-- ==============================================
		Title and Meta Tags
		=============================================== -->
		<meta charset="utf-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Admin - <?=e($this->siteSettings('title'))?></title>
		<meta name="description" content="<?=e($this->siteSettings('description'))?>">
		<meta name="keywords" content="<?=e($this->siteSettings('keywords'))?>">
		
		<!-- ==============================================
		Favicons
		=============================================== --> 
        <link href="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($this->siteSettings('favicon'))?>" rel="icon">
		
		<!-- ==============================================
		Fonts
		=============================================== --> 
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Work+Sans:300,400,700&amp;display=swap">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.1/css/all.css" integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">
        
		
		<!-- ==============================================
		CSS
		=============================================== --> 
        
            <!-- fontawesome icon -->
            <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/fonts/fontawesome/css/fontawesome-all.min.css">
            <!-- animation css -->
            <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/animation/css/animate.min.css">
            <!-- vendor css -->
            <?php if($data['lang'] == "english"){ ?>
                <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/css/rtl_style_en.css">
            <?php }else{ ?>
                <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/css/rtl_style.css">
            <?php } ?>
            
            <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote.min.css">
        
		<!-- ==============================================
		Scripts
		=============================================== --> 
        <?php if($data['url'] == 'voter_results' || $data['url'] == 'results' || $data['url'] == 'sms'): ?>
          <script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
          <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/js/vendor-all.min.js"></script>
          <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/bootstrap/js/bootstrap.min.js"></script>
          <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/sweetalert/sweetalert.min.js"></script> 
          <script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
          <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
          <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
          <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
          <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
          <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
          <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>   
          <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
        <?php else: ?>
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/js/vendor-all.min.js"></script>
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/bootstrap/js/bootstrap.min.js"></script>
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/sweetalert/sweetalert.min.js"></script> 
         <script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>   
         <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
        <?php endif; ?>
        
		
		<!-- Global site tag (gtag.js) - Google Analytics -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=<?=e($this->siteSettings('analytics'))?>"></script>
		<script>
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());

		  gtag('config', '<?=e($this->siteSettings('analytics'))?>');
		</script>	
  </head>
  
<body>
     
     <!-- ==============================================
     Wrapper Section
     =============================================== -->
	 <div class="wrapper">
			<?php if($data['url'] != 'login'): ?>
		      <?=$data['navigation_view']?>
		      <?=$data['sidenav_view']?>
			<?php endif; ?>
	 	
			<?=$data['content_view']?>
	  
			<?=$data['footer_view']?>
        
	 
		<!-- ==============================================
		Scripts
		=============================================== --> 
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/js/pcoded.min.js"></script>
        <?php if($data['url'] == 'voter_results' || $data['url'] == 'results' || $data['url'] == 'sms'): ?>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/pdfmake/pdfmake.min.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/pdfmake/vfs_fonts.js"></script>
          <script>
        //   'copy', 'csv', 'excel', 'pdf', 
          $(document).ready( function () {
              pdfMake.fonts = {
                    SSTArabic: {
                            normal: 'SST-Arabic-Light.ttf',
                            bold: 'SST-Arabic-Light.ttf'
                    }
            };
            $('#myLab').DataTable({ 
                  "order": [[ 0, "desc" ]],
                  "pageLength": 25,
                    dom: 'Bfrtip',
                    buttons: [
                        {
                            "extend": "print",
                            "text": "Print",
                            "filename": "Report Name",
                            "className": "btn btn-green",
                            "charset": "utf-8",
                            "bom": "true",
                            init: function(api, node, config) {
                            }
                        },
                        {
                            "extend": "pdfHtml5",
                            "text": "PDF",
                            "filename": "Report Name",
                            "className": "btn btn-green",
                            "charset": "utf-8",
                            "bom": "true",
                            customize: function(doc) {
                                  doc.defaultStyle.font = 'SSTArabic'; //<-- set fontsize to 16 instead of 10 
                               } , 
                            init: function(api, node, config) {
                            },
                            exportOptions: {
                                columns: ':visible',
                                modifier: {order: 'index'},
                                format: {
                                    body: function (data, row, column, node) {
                                        const arabic = /[\u0600-\u06FF]/;
                                        console.log(data);
                                        
                                        var newData = $(data).text();
                                        
                                        if (arabic.test(newData)) {
                                            return newData.split(' ').reverse().join(' ');
                                        }
                                        return newData;
                                    },
                                    header: function (data, row, column, node) {
                                        const arabic = /[\u0600-\u06FF]/;
                                        console.log(data);
                                        
                                        var newData = $(data).text();
                                        if (arabic.test(newData)) {
                                            return newData.split(' ').reverse().join(' ');
                                        }
                                        return newData;
                                    }
                                }
                            }
                        },
                        {
                            "extend": "csvHtml5",
                            "text": "CSV",
                            "filename": "Report Name",
                            "className": "btn btn-green",
                            "charset": "utf-8",
                            "bom": "true",
                            init: function(api, node, config) {
                            }
                        },
                        {
                            "extend": "excelHtml5",
                            "text": "Excel",
                            "filename": "Report Name",
                            "className": "btn btn-green",
                            "charset": "utf-8",
                            "bom": "true",
                            init: function(api, node, config) {
                            }
                        },
                        {
                            "extend": "copyHtml5",
                            "text": "Copy",
                            "filename": "Report Name",
                            "className": "btn btn-green",
                            "charset": "utf-8",
                            "bom": "true",
                            init: function(api, node, config) {
                            }
                        }
                    ],
                    "language": {
                      "lengthMenu": "<?=$this->lang('menu_length')?> _MENU_",
                      "zeroRecords": "<?=$this->lang('menu_zero_records')?>",
                      "info": "<?=$this->lang('menu_info_page')?>_PAGE_ <?=$this->lang('menu_of')?> _PAGES_",
                      "infoEmpty": "<?=$this->lang('menu_info_empty')?>",
                      "infoFiltered": "",
                      "search": "<?=$this->lang('menu_search')?>",
                      "paginate": {
                            "first":      "<?=$this->lang('menu_page_first')?>",
                            "last":       "<?=$this->lang('menu_page_last')?>",
                            "next":       "<?=$this->lang('menu_page_next')?>",
                            "previous":   "<?=$this->lang('menu_page_previous')?>"
                        },
                  }
            });
          } );  

          </script>        
        <?php else: ?>
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/datatables/datatables.min.js"></script>
          <script>
          $(document).ready( function () {
            $('#myTable').DataTable({
                  "order": [[ 0, "desc" ]],
                  "pageLength": 25,
                  "language": {
                      "lengthMenu": "<?=$this->lang('menu_length')?> _MENU_",
                      "zeroRecords": "<?=$this->lang('menu_zero_records')?>",
                      "info": "<?=$this->lang('menu_info_page')?>_PAGE_ <?=$this->lang('menu_of')?> _PAGES_",
                      "infoEmpty": "<?=$this->lang('menu_info_empty')?>",
                      "infoFiltered": "",
                      "search": "<?=$this->lang('menu_search')?>",
                      "paginate": {
                            "first":      "<?=$this->lang('menu_page_first')?>",
                            "last":       "<?=$this->lang('menu_page_last')?>",
                            "next":       "<?=$this->lang('menu_page_next')?>",
                            "previous":   "<?=$this->lang('menu_page_previous')?>"
                        },
                  }
            });
            $("select[name='myTable_length']").removeClass("custom-select");
            $("select[name='myTable_length']").removeClass("custom-select-sm");
            $("#myTable_filter input").attr("placeholder", "<?=$this->lang('menu_search')?>");
            $("#myTable_filter label").addClass("row");
            $("#myTable_filter").attr("style","width: 100%;");
            $("#myTable_filter label input").addClass("col-md-6");
            $("#myTable_filter label input").addClass("mr-3 ml-3");
            
            $("#myTable_length label").addClass("row");
            $("#myTable_length").attr("style","width: 100%;");
            
            
            <?php if($data['lang'] == "english"){ ?>
                $("#myTable_length label").addClass("row ml-2");
            <?php }else{ ?>
                $("#myTable_length label").addClass("row mr-2");
            <?php } ?>
            
            $("#myTable_length label select").addClass("col-md-4");
            $("#myTable_length label select").addClass("mr-3 ml-3");
          } );  

          </script>     
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote.min.js"></script>
            <script>
                $(document).ready(function() {
                  $('#summernote,#summernote-1,#summernote-2,#summernote-3,#summernote-4').summernote({
                    height: 200,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'italic', 'underline', 'clear']], 
                        ['para', ['ul', 'ol', 'paragraph']],
                      ],				 
                  });
                });
            </script>          
        <?php endif; ?>      
         
         
			<?=$data['scripts_view']?>
	 	
     </div><!-- /.wrapper -->  
</body>
</html>