<?php

namespace Fir\Controllers;
 
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Candidate extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;
	
    public function index()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
			
		$validation = "";	
		
		/* Use User Library */
        $user = $this->library('User');
		$data['user'] = $user->data();
		if(!$user->isLoggedIn()):
			redirect('login');
		elseif($data['user']['user_type'] != 2):
			redirect('login');
		endif;
        
		/* Use Category Model */
		$categoryModel = $this->model('Category');
        $data['categories'] = $categoryModel->list();
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
		/* Use Input Library */
		$input = $this->library('Input');
        
        //Post
        if(isset($_POST['dashboard'])){
         if ($input->exists()) {

            $validator = $this->library('Validator');

            $validation = $validator->check($_POST, [
                  'name' => [
                     'required' => true,
                  ],
                  'tag_line' => [
                     'required' => true,
                  ],
                  'email' => [
                     'required' => true,
                     'email' => true,
                  ],
                  'background' => [
                     'required' => true,
                  ],
                  'education' => [
                     'required' => true,
                  ],
                  'career' => [
                     'required' => true,
                  ],
            ]);

            if (!$validation->fails()) {

                $update = $candidateModel->update($input->get('name'), 
                                                  $input->get('email'), 
                                                  $input->get('cpr'), 
                                                  $input->get('mobile'), 
                                                  $input->get('tag_line'), 
                                                  $input->get('category_id'), 
                                                  $input->get('background'), 
                                                  $input->get('education'), 
                                                  $input->get('career'), 
                                                  $data['user']['userid']);

                if ($update == 1) {
                    $_SESSION['message'][] = ['success', $this->lang['details_updated']];
                    redirect(CANDIDATE_URL .'/dashboard');
                } else {
                    $_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
                    redirect(CANDIDATE_URL .'/dashboard');
                }

             } else {

                 foreach ($validation->errors()->all() as $err) {
                    $str = implode(" ",$err);
                     foreach ($err as $r) {
                        $_SESSION['errors'][] = ['error', $r];
                     }	
                 }

                    redirect(CANDIDATE_URL .'/dashboard');
           }

         }
        }        


        return ['content' => $this->view->render($data, 'candidate/dashboard')];
    }
    
    public function register()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
			
		$validation = "";	
		
		/* Use User Model */
        $user = $this->library('User');
		if($user->isLoggedIn() === true):
		 redirect(CANDIDATE_URL.'/dashboard');
		endif;
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
        
        if($data['settings']['allow_cand_reg'] == 0):
            redirect('login');
		endif;
		
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		
		/* Use Category Model */
		$categoryModel = $this->model('Category');
        $data['categories'] = $categoryModel->list();
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		/* Use User Library */
        $user = $this->library('User');

        // If the user tries to log-in
		if(isset($_POST['candidate_register'])) {
		 if ($input->exists()) {
		
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
				  'name' => [
					 'required' => true,
					 'minlength' => 2,
				   ],
				  'email' => [
					 'required' => true,
					 'email' => true,
					 'minlength' => 2,
				  ]
			]);
				 
			if (!$validation->fails()) {
					
				if(strlen((string)$_POST['cpr']) == 9 && strlen((string)$_POST['mobile']) == 8){
				
				$has = $candidateModel->hasCpr($input->get('cpr'));
				if($has === false):
		
					/* Hass Password */
					$password = password_hash(PASSWORD, PASSWORD_DEFAULT);
					
					/* Unique ID */	
					$userid = $this->uniqueid();	
					
					$remember = null;			
			
					$Insert = $candidateModel->register($userid, $input->get('name'), $input->get('email'), $input->get('cpr'), $input->get('mobile'), $password, $input->get('category_id')); 
					
					if ($Insert == 1) {

						// Attempt to auth the user
						$auth = $user->login(
							 $input->get('cpr'),
							 PASSWORD,
							 $remember
						  );

						// If the user has been logged-in
						if($auth) {
						    
						    $_SESSION['user_type'] = $user->data()["user_type"];
    						$_SESSION['cpr'] = $input->get('cpr');
    						$_SESSION['password'] = PASSWORD;
    						$_SESSION['remember'] = $remember;
    						$_SESSION['is_admin'] = 0;
    						redirect('otp');
							//redirect(CANDIDATE_URL.'/dashboard');
						}
						// If the user could not be logged-in
						elseif(isset($_POST['login'])) {
							$_SESSION['message'][] = ['error', $this->lang['invalid_user_pass']];
						}
						
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['error_when_saving']];
						redirect(CANDIDATE_URL.'/register');
					}
				elseif($has === true):
						$_SESSION['message'][] = ['warning', $this->lang['cpr_already_exists']];
						redirect(CANDIDATE_URL.'/register');
                endif;	
                
				}else{
						$_SESSION['message'][] = ['error', $this->lang['invalid_cpr_mobile']];
						redirect(CANDIDATE_URL.'/register');
				}			
					

			}else {
			 foreach ($validation->errors()->all() as $err) {
				$str = implode(" ",$err);
				 foreach ($err as $r) {
					$_SESSION['errors'][] = ['error', $r];
				 }	
			 }
						redirect(CANDIDATE_URL.'/register');
			}
		 }	
		}

        return ['content' => $this->view->render($data, 'candidate/register')];
    }    
	
    public function logout() {
        $user = $this->library('User');
		
		$user->logout();
		
		redirect('login');
    }
    
    public function image()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use User Library */
        $user = $this->library('User');
		$data['user'] = $user->data();
		if(!$user->isLoggedIn()):
			redirect('login');
		elseif($data['user']['user_type'] != 2):
			redirect('login');
		endif;
        
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		
		/* Use Input Library */
		$input = $this->library('Input');
		

		/*Edit Image Data*/
		if(isset($_POST['picture'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/users/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['user']['imagelocation'] ?? null;

					// Remove the old variant of the image
					if($data['user']['imagelocation'] != "default.png"):
						if($oldFileName && $oldFileName != $fileName) {
							unlink($path.$oldFileName);
						}
					endif;	
						
                    $update = $candidateModel->changeImage($fileName, $data['user']['userid']);

                    if ($update == 1) {
                        $_SESSION['message'][] = ['success', $this->lang['details_updated']];
                        redirect(CANDIDATE_URL .'/image');
                    } else {
                        $_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
                        redirect(CANDIDATE_URL .'/image');
                    }		  

                  }else{
                    $_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
                        redirect(CANDIDATE_URL .'/image');
                  }
               }else{
                    $_SESSION['message'][] = ['error', $this->lang['format_error']];
                        redirect(CANDIDATE_URL .'/image');
               }
              }else{
                    $_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
                        redirect(CANDIDATE_URL .'/image');
              }	
			
		 }	
		}

        return ['content' => $this->view->render($data, 'candidate/image')];
    }
	
    public function password()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
        
		/* Use User Library */
        $user = $this->library('User');
		$data['user'] = $user->data();
		if(!$user->isLoggedIn()):
			redirect('login');
		elseif($data['user']['user_type'] != 2):
			redirect('login');
		endif;
		
		/*Use User Model*/
        $userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');

		
		//Edit
		if(isset($_POST['edit_password'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
				  'password_current' => [
					 'required' => true,
				  ],
				   'password' => [
					 'required' => true,
				   ],
				   'confirmPassword' => [
					 'required' => true,
					 'match' => 'password'
				   ]
			]);
				 
			if (!$validation->fails()) {

				if (password_verify($input->get('password_current'), $data['user']['password'])) {
					
					/* Hash Password */
					$password = password_hash($input->get('password'), PASSWORD_DEFAULT);
					
					$update = $userModel->password($password, $data['user']['userid']);
						
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect(CANDIDATE_URL .'/password');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect(CANDIDATE_URL .'/password');
					}
					
				} else {
					
					$_SESSION['message'][] = ['error', $this->lang['current_password_does_not_match']];
						redirect(CANDIDATE_URL .'/password');
				 
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
						redirect(CANDIDATE_URL .'/password');
		   }

		 }
		}	

        return ['content' => $this->view->render($data, 'candidate/password')];
    }
	
	//Random String
	private function rando($length = 14){
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < $length; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		return $str;
	}
	
	//Random String
	function uniqueid()
	{
		$un = substr(number_format(time() * rand(),0,'',''),0,12);
		return $un;
	}
}