<?php

namespace Fir\Controllers;

class Instruction extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;
	
    public function index()
    {
        if (isset($this->url[0]) && $this->url[0] == 'lang') {
            $this->updateLanguage($this->url[1]);
        }

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];

		/*Use User Library*/
        $user = $this->library('User');
		$data['user'] = $user->data();
		$data['user_isloggedin'] = $user->isLoggedIn();
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
		/* Use Admin Model */
        $adminModel = $this->model('Admin');;
		$data['start'] = $adminModel->start_array();       
        $now = date('Y-m-d H:i:s');
        $date_to_now = strftime("%b %d, %Y", strtotime($now));
        $data['date_to_now'] = $date_to_now;
		
		/* Use Category Model */
		$categoryModel = $this->model('Category');
        $data['categories'] = $categoryModel->list();
        $data['count'] = $categoryModel->countCandidates();
        
        return ['content' => $this->view->render($data, 'home/instruction')];
    }
	
}