<?php

namespace Fir\Controllers;

class Register extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;
	
    public function index()
    {
        if (isset($this->url[0]) && $this->url[0] == 'lang') {
            $this->updateLanguage($this->url[1]);
        }

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
			
		$validation = "";	
		
		/* Use User Model */
        $user = $this->library('User');
		$data['user'] = $user->data();
		if($user->isLoggedIn() === true):
            if($data['user']['user_type'] == 1):
                redirect('user/dashboard');
            elseif($data['user']['user_type'] == 2):
                redirect(CANDIDATE_URL.'dashboard');
            endif;
		endif;
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
        
        if($data['settings']['allow_voter_reg'] == 0):
            redirect('login');
		endif;
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
		/* Use User Model */
		$userModel = $this->model('User');

        // If the user tries to log-in
		if(isset($_POST['register'])) {
		 if ($input->exists()) {
		
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
				  'name' => [
					 'required' => true,
					 'minlength' => 2,
				   ],
				  'email' => [
					 'required' => true,
					 'email' => true,
					 'minlength' => 2,
				  ]
			]);
				 
			if (!$validation->fails()) {
					
				if(strlen((string)$_POST['cpr']) == $data['settings']['cpr_char_limit'] && strlen((string)$_POST['mobile']) == $data['settings']['sms_char_limit']){	
				
    				$has = $userModel->hasCpr($input->get('cpr'));
    				if($has === false):
		
					/* Hass Password */
					$password = password_hash(PASSWORD, PASSWORD_DEFAULT);
					
					/* Unique ID */	
					$userid = $this->uniqueid();	
					
					$remember = null;			
			
					$Insert = $userModel->add($userid, $input->get('name'), $input->get('email'), $input->get('cpr'), $input->get('mobile'), $password); 
					
					if ($Insert == 1) {

						// Attempt to auth the user
						$auth = $user->login(
							 $input->get('cpr'),
							 PASSWORD,
							 $remember
						  );

						// If the user has been logged-in
						if($auth) {
						    $_SESSION['user_type'] = $user->data()["user_type"];
    						$_SESSION['cpr'] = $input->get('cpr');
    						$_SESSION['password'] = PASSWORD;
    						$_SESSION['remember'] = $remember;
    						$_SESSION['is_admin'] = 0;
    						redirect('otp');
							//redirect('user/dashboard');
						}
						// If the user could not be logged-in
						elseif(isset($_POST['login'])) {
							$_SESSION['message'][] = ['error', $this->lang['invalid_user_pass']];
						}
						
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['error_when_saving']];
						redirect('register');
					}
				elseif($has === true):
						$_SESSION['message'][] = ['warning', $this->lang['cpr_already_exists']];
						redirect('register');
                endif;
                
				}else{
						$_SESSION['message'][] = ['error', $this->lang['invalid_cpr_mobile']];
				}				
					

			}else {
			 foreach ($validation->errors()->all() as $err) {
				$str = implode(" ",$err);
				 foreach ($err as $r) {
					$_SESSION['errors'][] = ['error', $r];
				 }	
			 }
						redirect('register');
			}
		 }	
		}

        return ['content' => $this->view->render($data, 'home/register')];
    }


	
	//Random String
	function uniqueid()
	{
		$un = substr(number_format(time() * rand(),0,'',''),0,12);
		return $un;
	}
}