<?php

namespace Fir\Controllers;

use Aws\S3\S3Client;

class Requests extends Controller {

    /**
     * @var object
     */
    protected $model;

    public function index() {
        redirect();
    }

    public function search() {
        $model = $this->model('Requests');

        // Get the available locations
		$adminModel = $this->model('Admin');
        $data['currency'] = $adminModel->currencyDetails();
		
        return ['results' => $this->view->render($data, 'requests/search')];
    }

    public function delete_category() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->delete_category($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['deleted_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_delete'];
		 }	

        return $response;
    }

    public function delete_candidate() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->delete_candidate($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['deleted_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_delete'];
		 }	

        return $response;
    }

    public function delete_voting() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->delete_voting($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['deleted_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_delete'];
		 }	

        return $response;
    }

    public function resume_voting() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->resume_voting($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['resumed_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_resume'];
		 }

        return $response;
    }

    public function finish_voting() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->finish_voting($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['finished_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_finish'];
		 }

        return $response;
    }

    public function approve_voter() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->approve_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['approved_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_approve'];
		 }

        return $response;
    }

    public function decline_voter() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->decline_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['declined_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_decline'];
		 }

        return $response;
    }

    public function approve_candidate() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->approve_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['approved_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_approve'];
		 }

        return $response;
    }

    public function decline_candidate() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->decline_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['declined_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_decline'];
		 }

        return $response;
    }

    public function delete_voter() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->delete_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = 'success';
				$response['message'] = $this->lang['deleted_successfully'];
		 } else {
				$response['status']  = 'error';
				$response['message'] = $this->lang['unable_to_delete'];
		 }	

        return $response;
    }

    public function send_sms() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		$adminModel = $this->model('Admin');
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
        $mess = $input->get('message');
        $mobile = $data['settings']['sms_country_code'] . $input->get('mobile');
						
		$MessageBird = new \MessageBird\Client($data['settings']['sms_key']);
		$Message = new \MessageBird\Objects\Message();
		$Message->originator = $data['settings']['sms_from'];
		$Message->recipients = array($mobile);
		$Message->datacoding = 'unicode';
		$Message->body = $mess;

		try{
			$MessageBird->messages->create($Message);
			$adminModel->insert_sms_logs($mobile,$mess,1);
			$response['status']  = "success";
			$response['message'] = $this->lang['sms_success'] . $mobile;

		}catch(Exception $e){
			$adminModel->insert_sms_logs($mobile,$mess,0);
			$response['status']  = "error";
			$response['message'] = $this->lang['sms_failed'] . $mobile;
		}

        return $response;
    }
    
    public function addVoter(){
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
		$validator = $this->library('Validator');
			
		$validation = $validator->check($_GET, [
			  'name' => [
				 'required' => true,
				 'minlength' => 2,
			   ],
			  'email' => [
				 'required' => true,
				 'email' => true,
				 'minlength' => 2,
			  ]
		]);
			 
		if (!$validation->fails()) {
		    
		    /* Use User Model */
    		$userModel = $this->model('User');
    		
    		$has = $userModel->hasCpr($input->get('cpr'));
    		if($has === false):
    
        		/* Hass Password */
        		$password = password_hash(PASSWORD, PASSWORD_DEFAULT);
        		
        		/* Unique ID */	
        		$userid = $this->uniqueid();	
        		
        		$remember = null;			
        
        		$Insert = $userModel->add($userid, $input->get('name'), $input->get('email'), $input->get('cpr'), $input->get('mobile'), $password); 
        		
        		if ($Insert == 1) {
        
        			$response['status']  = "success";
    			    $response['message'] = $this->lang['success_add_voter'];
        			
        		} else {
        			$response['status']  = "error";
    			    $response['message'] = $this->lang['error_when_saving'];
        		}
        		
    	    elseif($has === true):
    			$response['status']  = "warning";
    			$response['message'] = $this->lang['cpr_already_exists'];
            endif;
		    
		}else{
		    
		    $response['status']  = "error";
    	    $response['message'] = $this->lang['error_when_saving'];
		    
		}
		
		
        
        return $response;
		
    }
    
    public function updateVoter(){
        $model = $this->model('Requests');
		$input = $this->library('Input');
		$validator = $this->library('Validator');
			
		$validation = $validator->check($_GET, [
			  'name' => [
				 'required' => true,
				 'minlength' => 2,
			   ],
			  'email' => [
				 'required' => true,
				 'email' => true,
				 'minlength' => 2,
			  ]
		]);
			 
		if (!$validation->fails()) {
		    
		    /* Use User Model */
    		$userModel = $this->model('User');
    
    		$Insert = $userModel->updateVoter($input->get('name'), $input->get('email'), $input->get('cpr'), $input->get('mobile'), $input->get('voter_id')); 

    		if ($Insert == 1) {
    
    			$response['status']  = "success";
			    $response['message'] = $this->lang['success_add_voter'];
			    
    		    if(!empty($input->get('password'))){
    		        /* Hass Password */
    		        $password = password_hash($input->get('password'), PASSWORD_DEFAULT);
    		        $userModel->updateVoterPassword($password, $input->get('voter_id')); 
    		    }
    			
    		} else {
    			$response['status']  = "error";
			    $response['message'] = $this->lang['error_when_saving'];
    		}
		    
		}else{
		    
		    $response['status']  = "error";
    	    $response['message'] = $this->lang['error_when_saving'];
		    
		}
        
        return $response;
		
    }
	
	//Random String
	public function rando($length = 14){
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < $length; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		return $str;
	}
	
	//Random String
	function uniqueid()
	{
		$un = substr(number_format(time() * rand(),0,'',''),0,12);
		return $un;
	}
		
}