<?php

namespace Fir\Controllers;

class Vote extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;
	
    public function index()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
        
		/* Use Category Model */
		$categoryModel = $this->model('Category');
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		
		
		/* Use Input Library */
		$input = $this->library('Input');
        
        //Post
        if(isset($_POST['post_vote'])){
         if ($input->exists()) {

            $validator = $this->library('Validator');

            $validation = $validator->check($_POST, [
            ]);
            
            if (!$validation->fails()) {
                $canProceed = "1";
                foreach($input->get('candidate') as $candidate){
                    
                    $has_vote = $candidateModel->has_voted($input->get('category'), 
                                                $candidate,
                                                  $input->get('voter'));

                    if($has_vote > 0){
                        $canProceed = "0";
                        break;
                    }
                }
                
                if($canProceed == "1"){
                    foreach($input->get('candidate') as $candidate){
                        $update = $candidateModel->vote($input->get('category'), 
                                                    $candidate,
                                                      $input->get('voter'));
                    }
                    
                    $user = $this->library('User');
                    
                    /* Use Settings Model */
            		$settingsModel = $this->model('Settings');
                    $data['settings'] = $settingsModel->get();
                    
                    $mobile = $data['settings']['sms_country_code'] . $user->data()['mobile'];
                    
        			$MessageBird = new \MessageBird\Client($data['settings']['sms_key']);
        			$Message = new \MessageBird\Objects\Message();
        			$Message->originator = $data['settings']['sms_from'];
        			$Message->recipients = array($mobile);
        			$Message->datacoding = 'unicode';
        			$Message->body = $this->lang['voted_successfully'];
                    
                    $log_succ = $this->lang['voted_successfully'];
                    $log_failed = $this->lang['sms_failed_tbl'];
                    
                    /* Use Admin Model */
		            $adminModel = $this->model('Admin');
            
        			try{
        				$MessageBird->messages->create($Message);
        				$adminModel->insert_sms_logs($mobile,$log_succ, 1);
        			}catch(Exception $e){
        			    $adminModel->insert_sms_logs($mobile,$log_failed, 0);
        			}
                    
                    if ($update == 1) {
                        $_SESSION['message'][] = ['success', $this->lang['voted_successfully']];
                        redirect(CATEGORY_URL .'/'. $input->get('category'));
                    } else {
                        $_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
                        redirect(CATEGORY_URL .'/'. $input->get('category'));
                    }
                    
                }else{
                        $_SESSION['message'][] = ['success', $this->lang['invalid_vote']];
                        redirect(CATEGORY_URL .'/'. $input->get('category'));
                }
                
             } else {

                 foreach ($validation->errors()->all() as $err) {
                    $str = implode(" ",$err);
                     foreach ($err as $r) {
                        $_SESSION['errors'][] = ['error', $r];
                     }	
                 }

                    redirect(CATEGORY_URL .'/'. $input->get('category'));
           }

         }
        }
		
    }
	

	
	function getDomain($url){
		$pieces = parse_url($url);
		$domain = isset($pieces['host']) ? $pieces['host'] : '';
		if(preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)){
			return $regs['domain'];
		}
		return FALSE;
	}	

}