<?php

namespace Fir\Controllers;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Admin extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;

    public function index() {
        if (isset($this->url[1]) && $this->url[1] == 'lang') {
            $this->updateLanguage($this->url[2]);
        }
        redirect('admin/login');
    }
	
    public function logout() {
        $admin = $this->library('Admin');
		
		$admin->logout();
		
		redirect('admin/login');
    }
	

    /**
     * @param $language string
     */
    private function updateLanguage($language)
    {
        setcookie('lang', $language, time() + (10 * 365 * 24 * 60 * 60), COOKIE_PATH);
        redirect('admin/dashboard');
    }
	
    public function login()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
			
		$validation = "";	

		/* Use Admin Model */
        $admin = $this->library('Admin');
		if($admin->isLoggedIn() === true):
		 redirect('admin/dashboard');
		endif;
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();

        // If the user tries to log-in
			if(isset($_POST['login'])) {
		
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'email' => [
				 'required' => true,
				 'minlength' => 2,
				 'maxlength' => 200
			   ],
			  'password' => [
				 'required' => true,
				 'minlength' => 2,
				 'maxlength' => 200
			   ]
			]);
				 
			if (!$validation->fails()) {
					$email = $_POST['email'];
					$password = $_POST['password'];
					$remember = null;
					
					if(isset($_POST['remember'])) {
					  $remember = ($_POST['remember'] === 'on') ? true : false;
					}

					// Attempt to auth the user
					$auth = $admin->login(
						 $email,
						 $password,
						 $remember
					  );

					// If the user has been logged-in
					if($auth) {
						redirect('admin/dashboard');
					}
					// If the user could not be logged-in
					elseif(isset($_POST['login'])) {
						$_SESSION['message'][] = ['error', $this->lang['invalid_user_pass']];
					}

				}
			else {
			 foreach ($validation->errors()->all() as $err) {
				$str = implode(" ",$err);
				 foreach ($err as $r) {
					$_SESSION['errors'][] = ['error', $r];
				 }	
			 }
			}
		}	

        return ['content' => $this->view->render($data, 'admin/login')];
    }

    public function dashboard() {
        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('admin/login');
		endif;
		
		$data['themes'] = $this->getThemes();
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
		/* Use Admin Model */
        $adminModel = $this->model('Admin');
		$data['count_voters'] = $adminModel->count_voters();
		$data['count_candidates'] = $adminModel->count_candidates();
		$data['count_categories'] = $adminModel->count_categories();
		$data['has_start'] = $adminModel->has_start();
		$data['start'] = $adminModel->start();
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		//Update
		if(isset($_POST['edit_voting'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
				  'title' => [
					 'required' => true,
				  ],
				  'date_to_start' => [
					 'required' => true,
				  ],
				  'date_to_end' => [
					 'required' => true,
				  ],
				  'description' => [
					 'required' => true,
				  ],
			]);
				 
			if (!$validation->fails()) {
				
				$update = $adminModel->update_voting($input->get('title'), $input->get('date_to_start'), $input->get('date_to_end'), $input->get('description'), $input->get('id'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
					redirect('admin/dashboard');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
					redirect('admin/dashboard');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
					redirect('admin/dashboard');
		   }

		 }
		}		
		//Start
		if(isset($_POST['start_voting'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
				  'title' => [
					 'required' => true,
				  ],
				  'date_to_start' => [
					 'required' => true,
				  ],
				  'date_to_end' => [
					 'required' => true,
				  ],
				  'description' => [
					 'required' => true,
				  ],
			]);
				 
			if (!$validation->fails()) {
				
				$insert = $adminModel->start_voting($input->get('title'), $input->get('date_to_start'), $input->get('date_to_end'), $input->get('description'));
					
				if ($insert == 1) {
                    $_SESSION['message'][] = ['success', $this->lang['details_saved']];
					redirect('admin/dashboard');
                } else {
                    $_SESSION['message'][] = ['warning', $this->lang['error_when_saving']];
					redirect('admin/dashboard');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
					redirect('admin/dashboard');
		   }

		 }
		}

        
		
        return ['content' => $this->view->render($data, 'admin/dashboard')];
    }

    /**
     * Get the available Themes
     */
    private function getThemes() {
        $path = sprintf('%s/../../%s/%s/', __DIR__, PUBLIC_PATH, THEME_PATH);

        $themes = scandir($path);

        $output = [];
        foreach($themes as $theme) {
            // Check if the theme has an info.php file a && file_exists($path.$theme.'/icon.png)nd a thumbnail
            if(file_exists($path.$theme.'/info.php') && file_exists($path.$theme.'/icon.png')) {
                // Store the theme information
                require($path.$theme.'/info.php');
                $output[$theme]['name']     = $name;
                $output[$theme]['author']   = $author;
                $output[$theme]['url']      = $url;
                $output[$theme]['version']  = $version;
                $output[$theme]['bootstrap']  = $bootstrap;
                $output[$theme]['path']     = $theme;
            }
        }

        return $output;
    }


    public function profile() {
        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* URL */
		$data['m'] = $this->url[2];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('admin/login');
		endif;
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		/* Use Admin Model */
		$adminModel = $this->model('Admin');
		
		
		//Edit Profile Data
		if(isset($_POST['profile'])){
		 if ($input->exists()) {
			
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'username' => [
				 'required' => true,
				 'maxlength' => 20,
				 'minlength' => 2
			  ],
			  'name' => [
				 'required' => true,
				 'maxlength' => 100,
				 'minlength' => 2
			  ],
			  'email' => [
				 'required' => true,
				 'maxlength' => 255,
				 'email' => true
			   ]
			]);
				 
			if (!$validation->fails()) {
				
				
				$update = $adminModel->profileDetails($input->get('name'), $input->get('username'), $input->get('email'), $data['admin']['adminid']);
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
				    redirect('admin/profile/details');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
				    redirect('admin/profile/details');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('admin/profile/details');
		   }
         }
		}	

		/*Edit Image Data*/
		if(isset($_POST['picture'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['admin']['imagelocation'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $adminModel->profileImage($fileName, $data['admin']['adminid']); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('admin/profile/image');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('admin/profile/image');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('admin/profile/image');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('admin/profile/image');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('admin/profile/image');
			  }	
			
		 }	
		}

		/*Edit Password Data*/
		if(isset($_POST['password'])){
		 if ($input->exists()) {
		 
			
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'password_current' => [
				 'required' => true,
				 'maxlength' => 300
			  ],
			   'password_new' => [
				 'required' => true,
				 'minlength' => 6
			   ],
			   'password_new_again' => [
				 'required' => true,
				 'match' => 'password_new'
			   ]
			]);
				 
			if (!$validation->fails()) {

				if (password_verify($input->get('password_current'), $data['admin']['password'])) {
					
					/* Hash Password */
					$password = password_hash($input->get('password_new'), PASSWORD_DEFAULT);
					
					$update = $adminModel->password($password, $data['admin']['adminid']);
						
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('admin/profile/password');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('admin/profile/password');
					}
					
				} else {
					
					$_SESSION['message'][] = ['error', $this->lang['current_password_does_not_match']];
						redirect('admin/profile/password');
				 
				}
			  
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('admin/profile/password');
		     }	
		  
			
		 }
		}		
		
        return ['content' => $this->view->render($data, 'admin/profile')];
    }
	
	
	/**
	 * Settings Function
	 */
    public function settings() {
        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* URL */
		$data['m'] = $this->url[2];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('admin/login');
		endif;
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		/* Use Admin Model */
		$adminModel = $this->model('Admin');
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();

		//Edit Site Settings Data
		if(isset($_POST['postsite'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'sitename' => [
				 'required' => true,
				 'minlength' => 2
			  ],
			  'title' => [
				 'required' => true,
				 'minlength' => 2
			  ],
			  'description' => [
				 'required' => true,
				 'minlength' => 3
			   ],
			  'keywords' => [
				 'required' => true,
				 'minlength' => 3
			   ],
			  'timezone' => [
				 'required' => true,
			   ]
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->siteDetails($input->get('sitename'), $input->get('title'), $input->get('description'), $input->get('keywords'), $input->get('timezone'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
					redirect('admin/settings/site');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
					redirect('admin/settings/site');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('admin/settings/site');
		   }

		 }
		}		

		/*Edit Image Data*/
		if(isset($_POST['postlogo'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['logo'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteLogo($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('admin/settings/logo');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('admin/settings/logo');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('admin/settings/logo');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('admin/settings/logo');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('admin/settings/logo');
			  }	
			
		 }	
		}

		/*Edit Favicon*/
		if(isset($_POST['postfavicon'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['favicon'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteFavicon($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('admin/settings/favicon');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('admin/settings/favicon');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('admin/settings/favicon');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('admin/settings/favicon');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('admin/settings/favicon');
			  }	
			
		 }	
		}

		//Edit Analytics
		if(isset($_POST['postanalytics'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'analytics' => [
				 'required' => true,
			  ],
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->siteAnalytics($input->get('analytics'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
					redirect('admin/settings/analytics');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
					redirect('admin/settings/analytics');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('admin/settings/analytics');
		   }

		 }
		}

		//Edit Votes
		if(isset($_POST['post_votes'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'show_votes' => [
				 'required' => true,
			  ],
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->siteVotes($input->get('show_votes'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
					redirect('admin/settings/votes');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
					redirect('admin/settings/votes');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('admin/settings/votes');
		   }

		 }
		}

		//Edit Email
		if(isset($_POST['post_email'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'smtp_host' => [
				 'required' => true,
			  ],
			  'smtp_username' => [
				 'required' => true,
			  ],
			  'smtp_password' => [
				 'required' => true,
			  ],
			  'smtp_encryption' => [
				 'required' => true,
			  ],
			  'smtp_port' => [
				 'required' => true,
			  ],
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->email($input->get('smtp_host'), $input->get('smtp_username'), $input->get('smtp_password'), $input->get('smtp_encryption'), $input->get('smtp_port'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
				    redirect('admin/settings/email');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
				    redirect('admin/settings/email');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('admin/settings/email');
		   }

		 }
		}

		/*Edit Home Bg*/
		if(isset($_POST['post_home'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['home_bg'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteHomeBg($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('admin/settings/home');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('admin/settings/home');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('admin/settings/home');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('admin/settings/home');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('admin/settings/home');
			  }	
			
		 }	
		}

		/*Edit Home Bg*/
		if(isset($_POST['post_login'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['login_bg'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteLoginBg($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('admin/settings/login');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('admin/settings/login');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('admin/settings/login');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('admin/settings/login');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('admin/settings/login');
			  }	
			
		 }	
		}

		/*Edit Hero Bg*/
		if(isset($_POST['post_hero'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['hero_bg'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteHeroBg($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('admin/settings/hero');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('admin/settings/hero');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('admin/settings/hero');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('admin/settings/hero');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('admin/settings/hero');
			  }	
			
		 }	
		}
				
		
		
        return ['content' => $this->view->render($data, 'admin/settings')];
    }
    

    /**
     * Categories
     */
    public function category()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('admin/login');
		endif;
		
		/* Use Category Model */
		$categoryModel = $this->model('Category');
		
		/* Use Input Library */
		$input = $this->library('Input');
        
        // Edit Page
        if(isset($this->url[2]) && $this->url[2] == 'add') {			
			

		
				//Add Currency Data
				if(isset($_POST['add_category'])){
				 if ($input->exists()) {

					$validator = $this->library('Validator');
					
					$validation = $validator->check($_POST, [
						  'title' => [
							 'required' => true,
						  ],
					]);
						 
					if (!$validation->fails()) {
					   
						$slug = $this->slugify($input->get('title'));
						
						$insert = $categoryModel->add($input->get('title'), $slug);
							
						if ($insert == 1) {
							$_SESSION['message'][] = ['success', $this->lang['details_saved']];
							redirect('admin/'. CATEGORY_URL .'/add');
						} else {
							$_SESSION['message'][] = ['warning', $this->lang['error_when_saving']];
							redirect('admin/'. CATEGORY_URL .'/add');
						}
							
					 } else {

						 foreach ($validation->errors()->all() as $err) {
							$str = implode(" ",$err);
							 foreach ($err as $r) {
								$_SESSION['errors'][] = ['error', $r];
							 }	
						 }
                        
							redirect('admin/'. CATEGORY_URL .'/add');
				   }

				 }
				}
				
                return ['content' => $this->view->render($data, 'admin/category_add')];
                
        }elseif(isset($this->url[2]) && $this->url[2] == 'list'){
            
                $data['categories'] = $categoryModel->list();
				
                return ['content' => $this->view->render($data, 'admin/category_list')];
            
        }elseif(isset($this->url[2]) && $this->url[2] == 'graphs'){		
			
            $has = $categoryModel->has($this->url[3]);

            // If the currency requested exists
            if($has === true) {
                
                $data["category"] = $categoryModel->get($this->url[3]);
				
                $data["graphs"] = $categoryModel->graphs($this->url[3]);  
				
                return ['content' => $this->view->render($data, 'admin/category_graphs')];
				
            } else {
                redirect('admin/'. CATEGORY_URL .'/list');
            }
            
        }elseif(isset($this->url[2]) && $this->url[2] == 'edit') {			
			
            $has = $categoryModel->has($this->url[3]);

            // If the currency requested exists
            if($has === true) {
				
                $data["category"] = $categoryModel->get($this->url[3]);
			

		
				//Add Currency Data
				if(isset($_POST['edit_category'])){
				 if ($input->exists()) {

					$validator = $this->library('Validator');
					
					$validation = $validator->check($_POST, [
						  'title' => [
							 'required' => true,
						  ],
					]);
						 
					if (!$validation->fails()) {
					   
						$slug = $this->slugify($input->get('title'));
						
						$update = $categoryModel->update($input->get('title'), $slug, $input->get('id'));
							
						if ($update == 1) {
							$_SESSION['message'][] = ['success', $this->lang['details_updated']];
							redirect('admin/'. CATEGORY_URL .'/edit/'. $input->get('id'));
						} else {
							$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
							redirect('admin/'. CATEGORY_URL .'/edit/'. $input->get('id'));
						}
							
					 } else {

						 foreach ($validation->errors()->all() as $err) {
							$str = implode(" ",$err);
							 foreach ($err as $r) {
								$_SESSION['errors'][] = ['error', $r];
							 }	
						 }
                        
							redirect('admin/'. CATEGORY_URL .'/edit/'. $input->get('id'));
				   }

				 }
				}               
				
                return ['content' => $this->view->render($data, 'admin/category_edit')];
				
            } else {
                redirect('admin/'. CATEGORY_URL .'/list');
            }
        }       
    }
	


    /**
     * Candidates
     */
    public function candidate()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('admin/login');
		endif;
		
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		/* Use Category Model */
		$categoryModel = $this->model('Category');
		
		/* Use Input Library */
		$input = $this->library('Input');
        
        // Edit Page
        if(isset($this->url[2]) && $this->url[2] == 'add') {
            
           $data['categories'] = $categoryModel->list();	
            
                //Add Candidate Data
                if(isset($_POST['add_candidate'])){
                 if ($input->exists()) {

                    $validator = $this->library('Validator');

                    $validation = $validator->check($_POST, [
                          'name' => [
                             'required' => true,
                          ],
                          'tag_line' => [
                             'required' => true,
                          ],
                          'email' => [
                             'required' => true,
                             'email' => true,
                          ],
                          'password' => [
                             'required' => true,
                          ],
                    ]);

                    if (!$validation->fails()) {

                        /* HasH Password */
                        $password = password_hash($input->get('password'), PASSWORD_DEFAULT);

                        /* Unique ID */	
                        $userid = $this->uniqueid();


                        $valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");

                        $name = $_FILES['photoimg']['name'];
                        $size = $_FILES['photoimg']['size'];

                        if(!empty($name))
                        {

                          $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);

                          // If there is no error during upload and the file is PNG
                          if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
                           {
                             $fileName = date('y.m.d.H.i') . "-" . microtime(true) . "-" . mt_rand(0, 99999999) . '.' . $fileFormat;
                             // If the file can't be written on the disk (will return 0)
                             $path = sprintf('%s/../../%s/%s/admin/users/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);


                             if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
                              {

                                $insert = $candidateModel->add($userid, $input->get('name'), $input->get('email'), $password, $input->get('tag_line'), $input->get('category_id'), $fileName);

                                if ($insert == 1) {
                                    $_SESSION['message'][] = ['success', $this->lang['details_saved']];
                                    redirect('admin/'. CANDIDATE_URL .'/add');
                                } else {
                                    $_SESSION['message'][] = ['warning', $this->lang['error_when_saving']];
                                    redirect('admin/'. CANDIDATE_URL .'/add');
                                }


                              }else{
                                $_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
                                    redirect('admin/'. CANDIDATE_URL .'/add');
                              }
                           }else{
                                $_SESSION['message'][] = ['error', $this->lang['format_error']];
                                    redirect('admin/'. CANDIDATE_URL .'/add');
                           }
                          }else{
                                $_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
                                    redirect('admin/'. CANDIDATE_URL .'/add');
                          }					


                     } else {

                         foreach ($validation->errors()->all() as $err) {
                            $str = implode(" ",$err);
                             foreach ($err as $r) {
                                $_SESSION['errors'][] = ['error', $r];
                             }	
                         }

                                    redirect('admin/'. CANDIDATE_URL .'/add');
                   }

                 }
                }
				
                return ['content' => $this->view->render($data, 'admin/candidate_add')];
                
        }elseif(isset($this->url[2]) && $this->url[2] == 'list'){
            
                $data['categories'] = $categoryModel->list();	
            
                $data['candidates'] = $candidateModel->list();
				
                return ['content' => $this->view->render($data, 'admin/candidate_list')];
            
        }elseif(isset($this->url[2]) && $this->url[2] == 'approve'){
            
                $data['categories'] = $categoryModel->list();	
            
                $data['candidates'] = $candidateModel->approve();
        
                if(isset($this->url[3]) && $this->url[3] == '1'){ 

                    $m = $candidateModel->getId($this->url[4]);

                    $mail = new PHPMailer;

                    //Server settings
                    $mail->isSMTP();                                      // Set mailer to use SMTP
                    $mail->Host = $data['settings']['smtp_host'];  // Specify main and backup SMTP servers
                    $mail->SMTPAuth = true;                               // Enable SMTP authentication
                    $mail->Username = $data['settings']['smtp_username'];                 // SMTP username
                    $mail->Password = $data['settings']['smtp_password'];                           // SMTP password
                    $mail->SMTPSecure = $data['settings']['smtp_encryption'];                                  // Enable TLS encryption, `ssl` also accepted				
                    $mail->Port = $data['settings']['smtp_port'];                                    // TCP port to connect to	

                     $mail->setFrom($data['settings']['smtp_username'], $data['settings']['sitename']);
                     $mail->addAddress($m["email"], $m["name"]);
                     $mail->Subject = "Candidate Approved - " .$data['settings']['sitename'];
                     $mail->isHTML(true);
                     $mail->Body = "
                           <p>Hello ". $m["name"] ."</p>
                           <p>Your Candidate account has been approved, voters can now vote for you.</p>
                           <p>Click following link to login</p> 
                           <a href='". URL_PATH ."'>Login</a>
                           <p>Thank you.</p>
                     ";
                     $mail->send();	   	   

					 redirect('admin/'. CANDIDATE_URL .'/approve');

                }elseif(isset($this->url[3]) && $this->url[3] == '2'){     

                    $m = $candidateModel->getId($this->url[4]);

                    $mail = new PHPMailer;

                    //Server settings
                    $mail->isSMTP();                                      // Set mailer to use SMTP
                    $mail->Host = $data['settings']['smtp_host'];  // Specify main and backup SMTP servers
                    $mail->SMTPAuth = true;                               // Enable SMTP authentication
                    $mail->Username = $data['settings']['smtp_username'];                 // SMTP username
                    $mail->Password = $data['settings']['smtp_password'];                           // SMTP password
                    $mail->SMTPSecure = $data['settings']['smtp_encryption'];                                  // Enable TLS encryption, `ssl` also accepted				
                    $mail->Port = $data['settings']['smtp_port'];                                    // TCP port to connect to	

                     $mail->setFrom($data['settings']['smtp_username'], $data['settings']['sitename']);
                     $mail->addAddress($m["email"], $m["name"]);
                     $mail->Subject = "Candidate Declined - " .$data['settings']['sitename'];
                     $mail->isHTML(true);
                     $mail->Body = "
                           <p>Hello ". $m["name"] ."</p>
                           <p>Your account has been declined, voters cannot vote for you.</p>
                           <p>Thank you.</p>
                     ";
                     $mail->send();	   

					 redirect('admin/'. CANDIDATE_URL .'/approve');

                }
				
                return ['content' => $this->view->render($data, 'admin/candidate_approve')];
            
        }elseif(isset($this->url[2]) && $this->url[2] == 'edit') {			
			
            $has = $candidateModel->has($this->url[3]);
		
            /* URL */
            $data['m'] = $this->url[4];
            
            $data['categories'] = $categoryModel->list();	

            // If the currency requested exists
            if($has === true) {
				
                $data["candidate"] = $candidateModel->get($this->url[3]);
			

		
				//Add Currency Data
				if(isset($_POST['edit_details'])){
				 if ($input->exists()) {

					$validator = $this->library('Validator');
					
					$validation = $validator->check($_POST, [
                          'name' => [
                             'required' => true,
                          ],
                          'tag_line' => [
                             'required' => true,
                          ],
                          'email' => [
                             'required' => true,
                             'email' => true,
                          ],
					]);
						 
					if (!$validation->fails()) {
						
						$update = $candidateModel->update($input->get('name'), 
                                                          $input->get('email'), 
                                                          $input->get('tag_line'), 
                                                          $input->get('category_id'), 
                                                          $input->get('background'), 
                                                          $input->get('education'), 
                                                          $input->get('career'), 
                                                          $input->get('userid'));
							
						if ($update == 1) {
							$_SESSION['message'][] = ['success', $this->lang['details_updated']];
							redirect('admin/'. CANDIDATE_URL .'/edit/'. $input->get('userid') .'/details');
						} else {
							$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
							redirect('admin/'. CANDIDATE_URL .'/edit/'. $input->get('userid') .'/details');
						}
							
					 } else {

						 foreach ($validation->errors()->all() as $err) {
							$str = implode(" ",$err);
							 foreach ($err as $r) {
								$_SESSION['errors'][] = ['error', $r];
							 }	
						 }
                        
							redirect('admin/'. CANDIDATE_URL .'/edit/'. $input->get('userid') .'/details');
				   }

				 }
				}
                
                /*Edit Image*/
                if(isset($_POST['edit_image'])){
                 if ($input->exists()) {

                    $valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");

                    $name = $_FILES['photoimg']['name'];
                    $size = $_FILES['photoimg']['size'];

                    if(!empty($name))
                    {

                      $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);

                      // If there is no error during upload and the file is PNG
                      if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
                       {
                         $fileName = $this->rando().'.'.$fileFormat;
                         // If the file can't be written on the disk (will return 0)
                         $path = sprintf('%s/../../%s/%s/admin/users/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);


                         if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
                          {

							// Get the old image
							$oldFileName = $input->get('imagelocation') ?? null;

							// Remove the old variant of the image
							if($input->get('imagelocation') != "default.png"):
								if($oldFileName && $oldFileName != $fileName) {
									unlink($path.$oldFileName);
								}
							endif;	
						
							$update = $candidateModel->changeImage($fileName, $input->get('userid'));

                            if ($update == 1) {
                                $_SESSION['message'][] = ['success', $this->lang['details_updated']];
							    redirect('admin/'. CANDIDATE_URL .'/edit/'. $input->get('userid') .'/image');
                            } else {
                                $_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
							    redirect('admin/'. CANDIDATE_URL .'/edit/'. $input->get('userid') .'/image');
                            }		  

                          }else{
                            $_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
							    redirect('admin/'. CANDIDATE_URL .'/edit/'. $input->get('userid') .'/image');
                          }
                       }else{
                            $_SESSION['message'][] = ['error', $this->lang['format_error']];
							    redirect('admin/'. CANDIDATE_URL .'/edit/'. $input->get('userid') .'/image');
                       }
                      }else{
                            $_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
							    redirect('admin/'. CANDIDATE_URL .'/edit/'. $input->get('userid') .'/image');
                      }	

                 }	
                } 
				
                return ['content' => $this->view->render($data, 'admin/candidate_edit')];
				
            } else {
                redirect('admin/'. CANDIDATE_URL .'/list');
            }
        }       
    }
	


    /**
     * Verify Voters
     */
    public function verify_voters()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('admin/login');
		endif;
		
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
            
        $data['voters'] = $userModel->list();	
        
        if(isset($this->url[2]) && $this->url[2] == '1'): 
            
            $m = $userModel->getId($this->url[3]);
            
            $mail = new PHPMailer;

            //Server settings
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $data['settings']['smtp_host'];  // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                               // Enable SMTP authentication
            $mail->Username = $data['settings']['smtp_username'];                 // SMTP username
            $mail->Password = $data['settings']['smtp_password'];                           // SMTP password
            $mail->SMTPSecure = $data['settings']['smtp_encryption'];                                  // Enable TLS encryption, `ssl` also accepted				
            $mail->Port = $data['settings']['smtp_port'];                                    // TCP port to connect to	

             $mail->setFrom($data['settings']['smtp_username'], $data['settings']['sitename']);
             $mail->addAddress($m["email"], $m["name"]);
             $mail->Subject = "Voter Approved - " .$data['settings']['sitename'];
             $mail->isHTML(true);
             $mail->Body = "
                   <p>Hello ". $m["name"] ."</p>
                   <p>Your account has been approved, now login to Vote.</p>
                   <p>Click following link to login</p> 
                   <a href='". URL_PATH ."'>Login</a>
                   <p>Thank you.</p>
             ";
             $mail->send();	   
            
            redirect('admin/verify_voters');
            
        elseif(isset($this->url[2]) && $this->url[2] == '2'):     
            
            $m = $userModel->getId($this->url[3]);
            
            $mail = new PHPMailer;

            //Server settings
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $data['settings']['smtp_host'];  // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                               // Enable SMTP authentication
            $mail->Username = $data['settings']['smtp_username'];                 // SMTP username
            $mail->Password = $data['settings']['smtp_password'];                           // SMTP password
            $mail->SMTPSecure = $data['settings']['smtp_encryption'];                                  // Enable TLS encryption, `ssl` also accepted				
            $mail->Port = $data['settings']['smtp_port'];                                    // TCP port to connect to	

             $mail->setFrom($data['settings']['smtp_username'], $data['settings']['sitename']);
             $mail->addAddress($m["email"], $m["name"]);
             $mail->Subject = "Voter Declined - " .$data['settings']['sitename'];
             $mail->isHTML(true);
             $mail->Body = "
                   <p>Hello ". $m["name"] ."</p>
                   <p>Your account has been declined, you cannot vote.</p>
                   <p>Thank you.</p>
             ";
             $mail->send();	   
            
            redirect('admin/verify_voters');   
            
        endif;        

        return ['content' => $this->view->render($data, 'admin/voters_list')];    
    }

    /**
     * Voters
     */
    public function voters()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('admin/login');
		endif;
		
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
            
        $data['voters'] = $userModel->approved();	
        $data['voted'] = $userModel->voted();	

        return ['content' => $this->view->render($data, 'admin/voters_approved')];    
    }

    /**
     * Voter Results
     */
    public function voter_results()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('admin/login');
		endif;
		
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
            
        $data['voters'] = $userModel->approved();	
        $data['candidates'] = $userModel->candidates();	
        $data['votes'] = $userModel->votes();	

        return ['content' => $this->view->render($data, 'admin/voter_results')];    
    }

    /**
     * Results
     */
    public function results()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('admin/login');
		endif;
		
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		/* Use Category Model */
		$categoryModel = $this->model('Category');
        $data['categories'] = $categoryModel->list();	
        $data['candidates'] = $candidateModel->list();
        $data["count"] = $candidateModel->count();

        return ['content' => $this->view->render($data, 'admin/results')];    
    }
	

	
	//Random String
	private function rando($length = 14){
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < $length; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		return $str;
	}
	
	//Random String
	function uniqueid()
	{
		$un = substr(number_format(time() * rand(),0,'',''),0,12);
		return $un;
	}

		/**
	 * Return the slug of a string to be used in a URL.
	 *
	 * @return String
	 */
	private function slugify($text){
		// replace non letter or digits by -
		$text = preg_replace('~[^\pL\d]+~u', '-', $text);

		// transliterate
		$text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

		// remove unwanted characters
		$text = preg_replace('~[^-\w]+~', '', $text);

		// trim
		$text = trim($text, '-');

		// remove duplicated - symbols
		$text = preg_replace('~-+~', '-', $text);

		// lowercase
		$text = strtolower($text);

		if (empty($text)) {
		  return 'n-a';
		}

		return $text;
	}
	
}