<?php

namespace Fir\Models;

class Category extends Model {

    /**
     * @var string
     */
    public $username;

    /**
     * @var string
     */
    public $password;

    /**
     * @var string
     */
    public $rememberToken;
		
    /**
     * Add Author
     *
     */
    public function add($title, $slug) {

			
	    $Insert = $this->db->insert('categories', array(
		   'title' => $title,
		   'slug' => $slug,
		   'date_added' => date('Y-m-d H:i:s'),
		));	
		  
		return $Insert->rowCount();  
    }
    public function list()
    {
		
        $categories = $this->db->select('categories', '*', []);

        return $categories;
    }
    public function has($id) {

		$has = $this->db->has("categories", ["id" => $id]);		
		  
		return $has;  
    }
    public function get($id) {

		$query = $this->db->select("categories", "*", ["id" => $id]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function update($title, $slug, $id) {

		$Update = $this->db->update('categories',[
		   'title' => $title,
		   'slug' => $slug,
		],[
		    'id' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
    public function countCandidates() {
        
       $categories = $this->db->select('categories', '*', []);
       foreach ($categories as $row) {

         $g = $this->db->count('user', ["AND" => ["category_id" => $row["id"], "user_type" => 2, "approved" => 1]]);
          
          $count[] = [
               "category_id" => $row["id"],
               "g" => $g,
          ];

       } 
		return $count;  
    }
    
    
    public function hasSlug($id) {

		$has = $this->db->has("categories", ["slug" => $id]);		
		  
		return $has;  
    }
    public function getSlug($id) {

		$query = $this->db->select("categories", "*", ["slug" => $id]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function has_voted($userid, $id) {

       $has_voted = $this->db->has('votes', ["AND" => ["userid" => $userid, "category_id" => $id]]);
        
       return $has_voted;    
    }
    public function selected($userid, $id) {
        
       $r1 = [];    

       $has_voted = $this->db->has('votes', ["AND" => ["userid" => $userid, "category_id" => $id]]);
       if ($has_voted === true) {

         $q1 = $this->db->select('votes', '*', ["AND" => ["userid" => $userid, "category_id" => $id]]);
         foreach ($q1 as $r1) {}        
       }        
        
       return $r1;    
    }
    public function count($id) {
        
       $count = [];    

       $candidates = $this->db->select('user', '*', ["category_id" => $id, "user_type" => 2]);
       foreach ($candidates as $row) {

         $g = $this->db->count('votes', ["candidate" => $row["id"]]);
          
          $count[] = [
               "candidate_id" => $row["id"],
               "g" => $g,
          ];

        } 	
		  
		return $count;  
    }
    public function value($id) {
        
       $value = 0;
       $count = [];  

       $candidates = $this->db->select('user', '*', ["category_id" => $id, "user_type" => 2]);
       foreach ($candidates as $row) {

         $g = $this->db->count('votes', ["candidate" => $row["id"]]);

          $count[] = [
               "candidate_id" => $row["id"],
               "g" => $g,
          ];

        } 

         //$value = max(array_column($count, 'g'));
         if(!empty($count)) {$value = max(array_column($count, 'g')); } else { $value = 0; }    
		  
		return $value;  
    }
    
    public function graphs($id) {
        
       $percentage = 0;
       $count = [];  

       $categories = $this->db->select('categories', '*', ["AND" => ["id" => $id]]);
       foreach ($categories as $row) {

           $candidates = $this->db->select('user', '*', ["category_id" => $row["id"]]);
           foreach ($candidates as $candidate) {

             $total_votes = $this->db->count('votes', ["category_id" => $row["id"]]);
             $g = $this->db->count('votes', ["candidate" => $candidate["id"]]);

             if($g > 0):   
              $percentage = $g * 100 / $total_votes;
             else:
              $percentage = $g * 100;   
             endif;     


              $count[] = [
                   "label" => $candidate["name"]. ' - votes('. $g .')' ,
                   "y" => $percentage,
              ];
         
           }       

        }  
        
        //$da = json_encode($count);    
		  
		return $count;  
    }
    
	
	
}