<?php
defined('FIR') OR exit();
/**
 * The template for displaying Home page content
 */
?>
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="row">
		 	
                             <div class="col-lg-12">

                               <?=$this->message()?>
                               <?=$this->validation()?>

                              </div>
                    
                                <div class="col-sm-12">
                                    <h5 class="mt-2"><?=$this->lang('settings')?></h5>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-3 col-sm-12">
                                            <?php $selected = ($data['m'] == 'site') ? ' active' : ''; ?>
                                            <?php $logo = ($data['m'] == 'logo') ? ' active' : ''; ?>
                                            <?php $favicon = ($data['m'] == 'favicon') ? ' active' : ''; ?>
                                            <?php $analytics = ($data['m'] == 'analytics') ? ' active' : ''; ?>
                                            <?php $vo = ($data['m'] == 'votes') ? ' active' : ''; ?>
                                            <?php $email = ($data['m'] == 'email') ? ' active' : ''; ?>
                                            <?php $home = ($data['m'] == 'home') ? ' active' : ''; ?>
                                            <?php $login = ($data['m'] == 'login') ? ' active' : ''; ?>
                                            <?php $he = ($data['m'] == 'hero') ? ' active' : ''; ?>
                                            <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                                 <li><a href="<?=$this->siteUrl()?>/admin/settings/site" class="nav-link text-left<?php echo e($selected); ?>">
                                                  <em class="fa fa-fw fa-cogs text-white"></em>&nbsp;&nbsp;&nbsp;<?=$this->lang('site_settings')?>
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/admin/settings/logo" class="nav-link text-left<?php echo e($logo); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp;<?=$this->lang('logo')?>
                                                 </a></li>
                                                 <li><a href="<?=$this->siteUrl()?>/admin/settings/favicon" class="nav-link text-left<?php echo e($favicon); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('favicon')?>
                                                 </a></li>
                                                 <li><a href="<?=$this->siteUrl()?>/admin/settings/analytics" class="nav-link text-left<?php echo e($analytics); ?>">
                                                  <em class="fa fa-fw fa-line-chart text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('google_analytics')?> 
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/admin/settings/votes" class="nav-link text-left<?php echo e($vo); ?>">
                                                  <em class="fa fa-fw fa-line-chart text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('show_votes')?> 
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/admin/settings/email" class="nav-link text-left<?php echo e($email); ?>">
                                                  <em class="fa fa-fw fa-briefcase text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('email_settings')?> 
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/admin/settings/home" class="nav-link text-left<?php echo e($home); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('home_bg')?> 
                                                 </a></li> 
                                                 <li><a href="<?=$this->siteUrl()?>/admin/settings/login" class="nav-link text-left<?php echo e($login); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('login_bg')?> 
                                                 </a></li> 
                                                 <li><a href="<?=$this->siteUrl()?>/admin/settings/hero" class="nav-link text-left<?php echo e($he); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('hero_bg')?> 
                                                 </a></li>                                                

                                            </ul>
                                        </div>
                                        <div class="col-md-9 col-sm-12">
		                          <?php if ($data['m'] == 'site') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('site_settings')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/admin/settings" method="post">

                                                  <div class="form-group">	
                                                    <label><?=$this->lang('site_name')?></label>
                                                    <input type="text" name="sitename" class="form-control" value="<?=e($data['settings']['sitename'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('site_title')?></label>
                                                    <input type="text" name="title" class="form-control" value="<?=e($data['settings']['title'])?>"/>
                                                  </div>
                                                  <div class="form-group">
                                                    <label><?=$this->lang('site_description')?></label>		
                                                    <textarea type="text" name="description" class="form-control" rows="5"><?=e($data['settings']['description'])?></textarea>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('site_keywords')?></label>	
                                                    <textarea type="text" name="keywords" class="form-control" rows="5"><?=e($data['settings']['description'])?></textarea>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('timezone')?></label>
                                                    <select name="timezone" class="form-control">
                                                        <option value="<?=(e($data['settings']['timezone']) == "" ? ' selected' : '')?>"><?=$this->lang['default']?></option>
                                                        <?php foreach(timezone_identifiers_list() as $value): ?>
                                                            <option value="<?=e($value)?>"<?=(e($data['settings']['timezone']) == $value ? ' selected' : '')?>><?=e($value)?></option>
                                                        <?php endforeach ?>
                                                    </select>
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="postsite" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'logo') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('logo')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:200px; height: 200px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['logo'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/admin/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="postlogo" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>   
              
                                 <?php elseif ($data['m'] == 'favicon') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('favicon')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:200px; height: 200px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['favicon'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/admin/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="postfavicon" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>   
              
                                 <?php elseif ($data['m'] == 'analytics') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('google_analytics')?> (UA ID)</h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/admin/settings" method="post">

                                                  <div class="form-group">	
                                                    <input type="text" name="analytics" class="form-control" value="<?=e($data['settings']['analytics'])?>"/>
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="postanalytics" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'votes') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('show_votes')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/admin/settings" method="post">
                                                    
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('show_votes')?></label>
                                                    <select name="show_votes" class="form-control">
                                                        <option value="1"<?=(e($data['settings']['show_votes']) == "1" ? ' selected' : '')?>><?=$this->lang['yes']?></option>
                                                        <option value="2"<?=(e($data['settings']['show_votes']) == "2" ? ' selected' : '')?>><?=$this->lang['no']?></option>
                                                    </select>
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_votes" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'email') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('email_settings')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/admin/settings" method="post">
                                                    
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_host')?></label>	
                                                    <input type="text" name="smtp_host" class="form-control" value="<?=e($data['settings']['smtp_host'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_username')?></label>	
                                                    <input type="text" name="smtp_username" class="form-control" value="<?=e($data['settings']['smtp_username'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_password')?></label>	
                                                    <input type="text" name="smtp_password" class="form-control" value="<?=e($data['settings']['smtp_password'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_encryption')?></label>	
                                                    <input type="text" name="smtp_encryption" class="form-control" value="<?=e($data['settings']['smtp_encryption'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_port')?></label>	
                                                    <input type="text" name="smtp_port" class="form-control" value="<?=e($data['settings']['smtp_port'])?>"/>
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_email" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>   
              
                                 <?php elseif ($data['m'] == 'home') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('home_bg')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:400px; height: 300px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['home_bg'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/admin/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_home" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'login') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('login_bg')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:400px; height: 300px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['login_bg'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/admin/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_login" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>
              
                                 <?php elseif ($data['m'] == 'hero') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('hero_bg')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:400px; height: 300px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['hero_bg'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/admin/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_hero" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>                                      
                                            
                                  <?php endif; ?>            
                                            
                                       
                                        </div><!-- /col-lg-9 -->
                                    </div>
                                </div>                    
                    
                    
                </div> <!-- end col -->
            </div>		
         </div>		
      </div><!-- /.content-wrapper -->