<?php
defined('FIR') OR exit();
/**
 * The template for displaying Home page content
 */
?>
    <!-- [ Main Content ] start -->
    <div align="right" class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">

                               <?=$this->message()?>
                               <?=$this->validation()?>



                                    <div class="card">
                                        <div class="card-header">
                                            <h5><?=$this->lang('add')?> <?=$this->candidate_name()?></h5>
                                        </div>
                                        <div class="card-body">
                                    
                                        <form action="<?=$this->siteUrl()?>/cps/candidate/add" method="post" enctype="multipart/form-data">
                                            <div class="form-group">
                                                <label><?=$this->lang('name')?></label>
                                                <input type="text" name="name" class="form-control" value="<?php echo ((isset($_POST['name'])) ? $_POST['name'] : ''); ?>" placeholder="<?=$this->lang('name')?>">
                                            </div>
                                            <div class="form-group">
                                                <label><?=$this->lang('email')?></label>
                                                <input type="text" name="email" class="form-control" value="<?php echo ((isset($_POST['email'])) ? $_POST['email'] : ''); ?>" placeholder="<?=$this->lang('email')?>">
                                            </div>
                                            <div class="form-group">
                                                <label><?=$this->lang('cpr')?></label>
                                                <input type="text" name="cpr" class="form-control" value="<?php echo ((isset($_POST['cpr'])) ? $_POST['cpr'] : ''); ?>" maxlength="<?=e($data['settings']['cpr_char_limit'])?>" minlength="<?=e($data['settings']['cpr_char_limit'])?>"  placeholder="<?=$this->lang('cpr')?>">
                                            </div>
                                            <div class="form-group">
                                                <label><?=$this->lang('mobile')?></label>
                                                <input type="text" name="mobile" class="form-control" value="<?php echo ((isset($_POST['mobile'])) ? $_POST['mobile'] : ''); ?>" maxlength="<?=e($data['settings']['sms_char_limit'])?>" minlength="<?=e($data['settings']['sms_char_limit'])?>"  placeholder="<?=$this->lang('mobile')?>">
                                            </div>
                                            <!--<div class="form-group">-->
                                            <!--    <label><?=$this->lang('password')?></label>-->
                                            <!--    <input type="password" name="password" class="form-control" placeholder="<?=$this->lang('password')?>">-->
                                            <!--</div>-->
                                            <div class="form-group">
                                                <label><?=$this->lang('tag_line')?></label>
                                                <input type="text" name="tag_line" class="form-control" value="<?php echo ((isset($_POST['tag_line'])) ? $_POST['tag_line'] : ''); ?>" placeholder="<?=$this->lang('tag_line')?>">
                                            </div>
                                            <div class="form-group">
                                                <label><?=$this->category_name_plural()?></label>
                                                <select class="form-control" name="category_id">
                                                    <?php foreach($data['categories'] as $row){ ?>
                                                       <option value="<?=e($row['id'])?>" <?php echo ((isset($_POST['category_id'])) ? (($_POST['category_id'] == $row['id']) ? 'selected' : '') : ''); ?> ><?=e($row['title'])?></option> 
                                                    <?php } ?>   
                                                </select>  
                                            </div>
                                            <div class="form-group">
                                                <label><?=$this->lang('image')?></label>
                                                <input type="file" name="photoimg" id="photoimg" class="form-control" required>
                                            </div>
                                            
                                             <?=$this->token()?>
                                            
                                            <button type="submit" name="add_candidate" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                        </form>
                                            
                                            
                                        </div>
                                    </div>
                    
                </div> <!-- end col -->
            </div>		
         </div>		
      </div><!-- /.content-wrapper -->