<?php
defined('FIR') OR exit();
/**
 * The template for displaying Home page content
 */
?>
    <!-- [ Main Content ] start -->
    <div align="right" class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="row">
		 	
                             <div class="col-lg-12">

                               <?=$this->message()?>
                               <?=$this->validation()?>

                              </div>
                    
                                <div class="col-sm-12">
                                    <h5 class="mt-2"><?=$this->lang('settings')?></h5>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-3 col-sm-12">
                                            <?php $selected = ($data['m'] == 'site') ? ' active' : ''; ?>
                                            <?php $logo = ($data['m'] == 'logo') ? ' active' : ''; ?>
                                            <?php $favicon = ($data['m'] == 'favicon') ? ' active' : ''; ?>
                                            <?php $analytics = ($data['m'] == 'analytics') ? ' active' : ''; ?>
                                            <?php $vo = ($data['m'] == 'votes') ? ' active' : ''; ?>
                                            <?php $email = ($data['m'] == 'email') ? ' active' : ''; ?>
                                            <?php $sms = ($data['m'] == 'sms') ? ' active' : ''; ?>
                                            <?php $home = ($data['m'] == 'home') ? ' active' : ''; ?>
                                            <?php $login = ($data['m'] == 'login') ? ' active' : ''; ?>
                                            <?php $he = ($data['m'] == 'hero') ? ' active' : ''; ?>
                                            <?php $other = ($data['m'] == 'other_settings') ? ' active' : ''; ?>
                                            <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                                 <li ><a href="<?=$this->siteUrl()?>/cps/settings/site" class="nav-link text-right<?php echo e($selected); ?>">
                                                  <em class="fa fa-fw fa-cogs text-white"></em>&nbsp;&nbsp;&nbsp;<?=$this->lang('site_settings')?>
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/logo" class="nav-link text-right<?php echo e($logo); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp;<?=$this->lang('logo')?>
                                                 </a></li>
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/favicon" class="nav-link text-right<?php echo e($favicon); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('favicon')?>
                                                 </a></li>
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/analytics" class="nav-link text-right<?php echo e($analytics); ?>">
                                                  <em class="fa fa-fw fa-line-chart text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('google_analytics')?> 
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/votes" class="nav-link text-right<?php echo e($vo); ?>">
                                                  <em class="fa fa-fw fa-line-chart text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('show_votes')?> 
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/email" class="nav-link text-right<?php echo e($email); ?>">
                                                  <em class="fa fa-fw fa-briefcase text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('email_settings')?> 
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/sms" class="nav-link text-right<?php echo e($sms); ?>">
                                                  <em class="fa fa-fw fa-briefcase text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('sms_settings')?> 
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/home" class="nav-link text-right<?php echo e($home); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('home_bg')?> 
                                                 </a></li> 
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/login" class="nav-link text-right<?php echo e($login); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('login_bg')?> 
                                                 </a></li> 
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/hero" class="nav-link text-right<?php echo e($he); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('hero_bg')?> 
                                                 </a></li>           
                                                 <li><a href="<?=$this->siteUrl()?>/cps/settings/other_settings" class="nav-link text-right<?php echo e($other); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp; <?=$this->lang('other_settings')?> 
                                                 </a></li>   

                                            </ul>
                                        </div>
                                        <div class="col-md-9 col-sm-12">
		                          <?php if ($data['m'] == 'site') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('site_settings')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post">

                                                  <div class="form-group">	
                                                    <label><?=$this->lang('site_name')?></label>
                                                    <input type="text" name="sitename" class="form-control" value="<?=e($data['settings']['sitename'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('site_title')?></label>
                                                    <input type="text" name="title" class="form-control" value="<?=e($data['settings']['title'])?>"/>
                                                  </div>
                                                  <div class="form-group">
                                                    <label><?=$this->lang('site_description')?></label>		
                                                    <textarea type="text" name="description" class="form-control" rows="5"><?=e($data['settings']['description'])?></textarea>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('site_keywords')?></label>	
                                                    <textarea type="text" name="keywords" class="form-control" rows="5"><?=e($data['settings']['description'])?></textarea>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('timezone')?></label>
                                                    <select name="timezone" class="form-control">
                                                        <option value="<?=(e($data['settings']['timezone']) == "" ? ' selected' : '')?>"><?=$this->lang['default']?></option>
                                                        <?php foreach(timezone_identifiers_list() as $value): ?>
                                                            <option value="<?=e($value)?>"<?=(e($data['settings']['timezone']) == $value ? ' selected' : '')?>><?=e($value)?></option>
                                                        <?php endforeach ?>
                                                    </select>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('instruction')?></label>	
                                                    <textarea name="instruction" class="form-control shadow-sm py-4" rows="7" id="summernote"><?=e($data['settings']['instruction'])?></textarea>
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="postsite" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'logo') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('logo')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:200px; height: 200px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['logo'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="postlogo" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>   
              
                                 <?php elseif ($data['m'] == 'favicon') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('favicon')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:200px; height: 200px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['favicon'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="postfavicon" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>   
              
                                 <?php elseif ($data['m'] == 'analytics') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('google_analytics')?> (UA ID)</h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post">

                                                  <div class="form-group">	
                                                    <input type="text" name="analytics" class="form-control" value="<?=e($data['settings']['analytics'])?>"/>
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="postanalytics" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'votes') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('show_votes')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post">
                                                  
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('voters_reg')?></label>	
                                                    <div class="custom-control custom-radio custom-control-inline">
                                                      <input type="radio" id="customRadioInline11" <?=e(($data['settings']['show_votes'] == "1") ? "checked" : "")?> name="show_votes" value="1" class="custom-control-input">
                                                      <label class="custom-control-label" for="customRadioInline11"><?=$this->lang('yes')?></label>
                                                    </div>
                                                    <div class="custom-control custom-radio custom-control-inline">
                                                      <input type="radio" id="customRadioInline12" <?=e(($data['settings']['show_votes'] == "0") ? "checked" : "")?> name="show_votes" value="0" class="custom-control-input">
                                                      <label class="custom-control-label" for="customRadioInline12"><?=$this->lang('no')?></label>
                                                    </div>
                                                  </div>
                                                  

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_votes" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'email') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('email_settings')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post">
                                                    
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_host')?></label>	
                                                    <input type="text" name="smtp_host" class="form-control" value="<?=e($data['settings']['smtp_host'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_username')?></label>	
                                                    <input type="text" name="smtp_username" class="form-control" value="<?=e($data['settings']['smtp_username'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_password')?></label>	
                                                    <input type="text" name="smtp_password" class="form-control" value="<?=e($data['settings']['smtp_password'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_encryption')?></label>	
                                                    <input type="text" name="smtp_encryption" class="form-control" value="<?=e($data['settings']['smtp_encryption'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('smtp_port')?></label>	
                                                    <input type="text" name="smtp_port" class="form-control" value="<?=e($data['settings']['smtp_port'])?>"/>
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_email" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>   
                                        
                                <?php elseif ($data['m'] == 'sms') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('sms_settings')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post">
                                                    
                                                  <!--<div class="form-group">	-->
                                                  <!--  <label><?=$this->lang('sms_key')?></label>	-->
                                                  <!--  <input type="text" name="sms_key" class="form-control" value="<?=e($data['settings']['sms_key'])?>"/>-->
                                                  <!--</div>-->
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('sms_mode')?></label>	
                                                    <div class="custom-control custom-radio custom-control-inline">
                                                      <input type="radio" id="customRadioInline3" <?=e(($data['settings']['sms_key'] == "ijcTtMvBnmPTBU33jew121Aa1") ? "checked" : "")?> name="sms_key" value="ijcTtMvBnmPTBU33jew121Aa1"  class="custom-control-input">
                                                      <label class="custom-control-label" for="customRadioInline3"><?=$this->lang('sms_dev')?></label>
                                                    </div>
                                                    <div class="custom-control custom-radio custom-control-inline">
                                                      <input type="radio" id="customRadioInline4" <?=e(($data['settings']['sms_key'] == "iSZIKyblgRCwy3s7tFAj1FtQ9") ? "checked" : "")?> name="sms_key" value="iSZIKyblgRCwy3s7tFAj1FtQ9"  class="custom-control-input">
                                                      <label class="custom-control-label" for="customRadioInline4"><?=$this->lang('sms_prod')?></label>
                                                    </div>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('sms_from')?></label>	
                                                    <input type="text" name="sms_from" class="form-control" value="<?=e($data['settings']['sms_from'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('sms_country_code')?></label>	
                                                    <input type="text" name="sms_country_code" class="form-control" value="<?=e($data['settings']['sms_country_code'])?>"/>
                                                  </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_sms" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>   
              
                                 <?php elseif ($data['m'] == 'home') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('home_bg')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:400px; height: 300px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['home_bg'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_home" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'login') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('login_bg')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:400px; height: 300px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['login_bg'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_login" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>
              
                                 <?php elseif ($data['m'] == 'hero') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('hero_bg')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:400px; height: 300px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($data['settings']['hero_bg'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post" enctype="multipart/form-data">

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_hero" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>     
                                        
                                  <?php elseif ($data['m'] == 'other_settings') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('other_settings')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/cps/settings" method="post">
                                                    
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('sms_limit')?></label>	
                                                    <input type="text" name="sms_limit" class="form-control" value="<?=e($data['settings']['sms_char_limit'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('cpr_limit')?></label>	
                                                    <input type="text" name="cpr_limit" class="form-control" value="<?=e($data['settings']['cpr_char_limit'])?>"/>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('voters_reg')?></label>	
                                                    <div class="custom-control custom-radio custom-control-inline">
                                                      <input type="radio" id="customRadioInline1" <?=e(($data['settings']['allow_voter_reg'] == "1") ? "checked" : "")?> name="allow_voter_reg" value="1" class="custom-control-input">
                                                      <label class="custom-control-label" for="customRadioInline1"><?=$this->lang('yes')?></label>
                                                    </div>
                                                    <div class="custom-control custom-radio custom-control-inline">
                                                      <input type="radio" id="customRadioInline2" <?=e(($data['settings']['allow_voter_reg'] == "0") ? "checked" : "")?> name="allow_voter_reg" value="0" class="custom-control-input">
                                                      <label class="custom-control-label" for="customRadioInline2"><?=$this->lang('no')?></label>
                                                    </div>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('candidate_reg')?></label>	
                                                    <div class="custom-control custom-radio custom-control-inline">
                                                      <input type="radio" id="customRadioInline3" <?=e(($data['settings']['allow_cand_reg'] == "1") ? "checked" : "")?> name="allow_cand_reg" value="1"  class="custom-control-input">
                                                      <label class="custom-control-label" for="customRadioInline3"><?=$this->lang('yes')?></label>
                                                    </div>
                                                    <div class="custom-control custom-radio custom-control-inline">
                                                      <input type="radio" id="customRadioInline4" <?=e(($data['settings']['allow_cand_reg'] == "0") ? "checked" : "")?> name="allow_cand_reg" value="0"  class="custom-control-input">
                                                      <label class="custom-control-label" for="customRadioInline4"><?=$this->lang('no')?></label>
                                                    </div>
                                                  </div>
                                                  <div class="form-group">	
                                                    <label><?=$this->lang('languages')?></label>	
                                                    <select class="form-control" name="language" value="<?=e($data['settings']['language'])?>">
                                                        <?php foreach($data['language_list'] as $row){ ?>
                                                            <option value="<?=e($row)?>" <?php if($data['settings']['language'] == $row){echo 'selected';} ?>><?=e(ucfirst($row))?></option>
                                                        <?php } ?>
                                                    </select>
                                                  </div>
                                                  

                                                    <?=$this->token()?>

                                                    <button type="submit" name="post_other_settings" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>   
                                            
                                  <?php endif; ?>            
                                            
                                       
                                        </div><!-- /col-lg-9 -->
                                    </div>
                                </div>                    
                    
                    
                </div> <!-- end col -->
            </div>		
         </div>		
      </div><!-- /.content-wrapper -->