<?php
defined('FIR') OR exit();
/**
 * The main template file
 * This file puts together the three main section of the software, header, content and footer
 */
?>

<!DOCTYPE html>
<?php if($data['lang'] == "english"){ ?>
    <html>
<?php }else{ ?>
    <html dir="rtl">
<?php } ?>
	<head>
	    <!-- ==============================================
		Title and Meta Tags
		=============================================== -->
		<meta charset="utf-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title><?=e($this->siteSettings('sitename'))?> - <?=e($this->siteSettings('title'))?></title>
		<meta name="description" content="<?=e($this->siteSettings('description'))?>">
		<meta name="keywords" content="<?=e($this->siteSettings('keywords'))?>">
		
		<!-- ==============================================
		Favicons
		=============================================== --> 
        <link href="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($this->siteSettings('favicon'))?>" rel="icon">
		
		<!-- ==============================================
		Fonts
		=============================================== --> 
		
		<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Cairo:wght@200&display=swap">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Work+Sans:300,400,700&amp;display=swap">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.1/css/all.css" integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">
        
		
		<!-- ==============================================
		CSS
		=============================================== --> 
        <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/bootstrap/css/bootstrap.min.css">
        <?php if($data['lang'] == "english"){ ?>
            <link rel="stylesheet" type="text/css" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/css/rtl_base_en.css">
            <link rel="stylesheet" type="text/css" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/css/rtl_style_en.css">
        <?php }else{ ?>
            <link rel="stylesheet" type="text/css" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/css/rtl_base.css">
            <link rel="stylesheet" type="text/css" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/css/rtl_style.css">
        <?php } ?>
        <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote.min.css">
         
        <?php if($data['url'] == 'register'): ?>
        <link rel="stylesheet" type="text/css" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/css/login.css">
        <?php endif; ?> 
        
		<!-- ==============================================
		Scripts
		=============================================== --> 
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/jquery/jquery.min.js"></script>
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/js/front.js"></script>
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/sweetalert/sweetalert.min.js"></script>
        
		
		<!-- Global site tag (gtag.js) - Google Analytics -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=<?=e($this->siteSettings('analytics'))?>"></script>
		<script>
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());

		  gtag('config', '<?=e($this->siteSettings('analytics'))?>');
		</script>	
  </head>
  
<body>
     
     <!-- ==============================================
     Wrapper Section
     =============================================== -->
	 <div class="main">
         
			<?php if($data['url'] == 'register'): ?>
              <?=$data['content_view']?>
            <?php else: ?> 
		      <?=$data['header_view']?>
		      <?=$data['sidenav_view']?>
	 	      <?=$data['content_view']?>
		      <?=$data['footer_view']?>
			<?php endif; ?>
        
	 
		<!-- ==============================================
		Scripts
		=============================================== --> 
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/datatables/datatables.min.js"></script>
          <script>
          $(document).ready( function () {
            $('#myTable').DataTable({
                  "ordering": false,    
            });
          } );  

          </script>         
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote.min.js"></script>
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote-ext-rtl.js"></script>
            <script>
                $(document).ready(function() {
                  $('#summernote,#summernote-1,#summernote-2,#summernote-3,#summernote-4').summernote({
                    height: 200,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'italic', 'underline', 'clear']], 
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['insert',['ltr','rtl']],
                      ],				 
                  });
                });
            </script>
         
         
			<?=$data['scripts_view']?>
	 	
     </div><!-- /.wrapper -->  
</body>
</html>